/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;

public class BlastFurnaceRecipeSerializer
extends IERecipeSerializer<BlastFurnaceRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.BLAST_FURNACE);
    }

    @Override
    public BlastFurnaceRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        Lazy<ItemStack> output = BlastFurnaceRecipeSerializer.readOutput(json.get("result"));
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        int time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)200);
        Lazy<ItemStack> slag = IESerializableRecipe.LAZY_EMPTY;
        if (json.has("slag")) {
            slag = BlastFurnaceRecipeSerializer.readOutput((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"slag"));
        }
        return new BlastFurnaceRecipe(recipeId, output, input, time, slag);
    }

    @Nullable
    public BlastFurnaceRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Lazy<ItemStack> output = BlastFurnaceRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int time = buffer.readInt();
        Lazy<ItemStack> slag = IESerializableRecipe.LAZY_EMPTY;
        if (buffer.readBoolean()) {
            slag = BlastFurnaceRecipeSerializer.readLazyStack(buffer);
        }
        return new BlastFurnaceRecipe(recipeId, output, input, time, slag);
    }

    public void toNetwork(FriendlyByteBuf buffer, BlastFurnaceRecipe recipe) {
        BlastFurnaceRecipeSerializer.writeLazyStack(buffer, recipe.output);
        recipe.input.write(buffer);
        buffer.writeInt(recipe.time);
        buffer.writeBoolean(!((ItemStack)recipe.slag.get()).m_41619_());
        if (!((ItemStack)recipe.slag.get()).m_41619_()) {
            buffer.m_130055_((ItemStack)recipe.slag.get());
        }
    }
}

