/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeSerializer
extends IERecipeSerializer<FermenterRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.FERMENTER);
    }

    @Override
    public FermenterRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        FluidStack fluidOutput = FluidStack.EMPTY;
        if (json.has("fluid")) {
            fluidOutput = ApiUtils.jsonDeserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
        }
        Lazy<ItemStack> itemOutput = IESerializableRecipe.LAZY_EMPTY;
        if (json.has("result")) {
            itemOutput = FermenterRecipeSerializer.readOutput(json.get("result"));
        }
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        return IEServerConfig.MACHINES.fermenterConfig.apply(new FermenterRecipe(recipeId, fluidOutput, itemOutput, input, energy));
    }

    @Nullable
    public FermenterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        FluidStack fluidOutput = buffer.readFluidStack();
        Lazy<ItemStack> itemOutput = FermenterRecipeSerializer.readLazyStack(buffer);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int energy = buffer.readInt();
        return new FermenterRecipe(recipeId, fluidOutput, itemOutput, input, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, FermenterRecipe recipe) {
        buffer.writeFluidStack(recipe.fluidOutput);
        buffer.m_130055_((ItemStack)recipe.itemOutput.get());
        recipe.input.write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

