/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.util.IELogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.IntTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilitySkyhookData {
    public static final Capability<SkyhookUserData> SKYHOOK_USER_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<SkyhookUserData>(){});

    public static enum SkyhookStatus {
        NONE(null, null),
        RIDING(NONE, null),
        HOLDING_CONNECTING(null, NONE),
        HOLDING_FAILED(null, NONE),
        HOLDING_RIDING(HOLDING_FAILED, RIDING);

        @Nullable
        public final SkyhookStatus dismount;
        @Nullable
        public final SkyhookStatus release;
        @Nullable
        public SkyhookStatus mount;

        private SkyhookStatus(SkyhookStatus dismount, SkyhookStatus release) {
            this.dismount = dismount;
            this.release = release;
        }

        static {
            SkyhookStatus.NONE.mount = RIDING;
            SkyhookStatus.HOLDING_CONNECTING.mount = HOLDING_RIDING;
        }
    }

    public static class SimpleSkyhookProvider
    implements ICapabilityProvider,
    INBTSerializable<IntTag> {
        private final SkyhookUserData data = new SkyhookUserData();
        private final LazyOptional<SkyhookUserData> opt = CapabilityUtils.constantOptional(this.data);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == SKYHOOK_USER_DATA) {
                return this.opt.cast();
            }
            return LazyOptional.empty();
        }

        public IntTag serializeNBT() {
            return IntTag.m_128679_((int)this.data.status.ordinal());
        }

        public void deserializeNBT(IntTag nbt) {
            this.data.status = SkyhookStatus.values()[nbt.m_7047_()];
        }
    }

    public static class SkyhookUserData {
        private SkyhookStatus status = SkyhookStatus.NONE;
        @Nullable
        public SkylineHookEntity hook = null;

        public void release() {
            if (this.status.release != null) {
                this.status = this.status.release;
            }
        }

        public void dismount() {
            if (this.hook != null) {
                IELogger.logger.debug("Dismounting");
                this.hook.m_146870_();
                this.hook = null;
            }
            if (this.status.dismount != null) {
                this.status = this.status.dismount;
            }
        }

        public SkyhookStatus getStatus() {
            return this.status;
        }

        public void startHolding() {
            this.status = SkyhookStatus.HOLDING_CONNECTING;
        }

        public void startRiding() {
            this.status = this.status.mount;
        }
    }
}

