/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.function.IntConsumer;
import net.minecraft.util.Mth;

public class LayeredComparatorOutput {
    private final double maxValue;
    private final int numLayers;
    private final double layerSize;
    private final Runnable updateMaster;
    private final IntConsumer updateLayer;
    private double lastValue = -1.0;
    private int currentMasterOutput;
    private final int[] currentLayerOutputs;

    public LayeredComparatorOutput(double maxValue, int numLayers, Runnable updateMaster, IntConsumer updateLayer) {
        this.maxValue = maxValue;
        this.numLayers = numLayers;
        this.updateMaster = updateMaster;
        this.updateLayer = updateLayer;
        this.currentMasterOutput = 0;
        this.currentLayerOutputs = new int[numLayers];
        this.layerSize = maxValue / (double)numLayers;
    }

    public void update(double newValue) {
        if (newValue == this.lastValue) {
            return;
        }
        this.lastValue = newValue;
        int newMasterOutput = (int)(15.0 * newValue / this.maxValue);
        if (this.currentMasterOutput != newMasterOutput) {
            this.currentMasterOutput = newMasterOutput;
            this.updateMaster.run();
        }
        for (int layer = 0; layer < this.numLayers; ++layer) {
            double layerValue = newValue - (double)layer * this.layerSize;
            int newLayerOutput = (int)Mth.m_14008_((double)(15.0 * layerValue / this.layerSize), (double)0.0, (double)15.0);
            if (newLayerOutput == this.currentLayerOutputs[layer]) continue;
            this.currentLayerOutputs[layer] = newLayerOutput;
            this.updateLayer.accept(layer);
        }
    }

    public int getCurrentMasterOutput() {
        return this.currentMasterOutput;
    }

    public int getLayerOutput(int layer) {
        return this.currentLayerOutputs[layer];
    }
}

