/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.client.gui.AlloySmelterScreen;
import blusunrize.immersiveengineering.client.gui.ArcFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.AutoWorkbenchScreen;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.CokeOvenScreen;
import blusunrize.immersiveengineering.client.gui.CraftingTableScreen;
import blusunrize.immersiveengineering.client.gui.FermenterScreen;
import blusunrize.immersiveengineering.client.gui.FluidSorterScreen;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.MixerScreen;
import blusunrize.immersiveengineering.client.gui.ModWorkbenchScreen;
import blusunrize.immersiveengineering.client.gui.RefineryScreen;
import blusunrize.immersiveengineering.client.gui.SqueezerScreen;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.gui.CraftingTableContainer;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.AssemblerRecipeTransferHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.FluidSorterGhostHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.IEFluidTooltipCallback;
import blusunrize.immersiveengineering.common.util.compat.jei.IEGhostItemHandler;
import blusunrize.immersiveengineering.common.util.compat.jei.alloysmelter.AlloySmelterRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.arcfurnace.ArcFurnaceRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace.BlastFurnaceFuelCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace.BlastFurnaceRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.bottlingmachine.BottlingMachineRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.cloche.ClocheRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.cokeoven.CokeOvenRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.crusher.CrusherRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.fermenter.FermenterRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.metalpress.MetalPressRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.mixer.MixerRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.refinery.RefineryRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.sawmill.SawmillRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.squeezer.SqueezerRecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.workbench.WorkbenchRecipeCategory;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIHelper
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "main");
    public static final ResourceLocation JEI_GUI = new ResourceLocation("immersiveengineering", "textures/gui/jei_elements.png");
    public static IDrawableStatic slotDrawable;
    public static IRecipeSlotTooltipCallback fluidTooltipCallback;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(IEItems.Misc.BLUEPRINT.m_5456_(), (stack, $) -> EngineersBlueprintItem.getCategory(stack));
        for (IConveyorType<?> conveyor : ConveyorHandler.getConveyorTypes()) {
            Item item = ConveyorHandler.getBlock(conveyor).m_5456_();
            subtypeRegistry.registerSubtypeInterpreter(item, (stack, $) -> ItemNBTHelper.getString(stack, "defaultCover"));
        }
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CokeOvenRecipeCategory(guiHelper), new AlloySmelterRecipeCategory(guiHelper), new BlastFurnaceRecipeCategory(guiHelper), new BlastFurnaceFuelCategory(guiHelper), new ClocheRecipeCategory(guiHelper), new MetalPressRecipeCategory(guiHelper), new CrusherRecipeCategory(guiHelper), new SawmillRecipeCategory(guiHelper), new WorkbenchRecipeCategory(guiHelper), new SqueezerRecipeCategory(guiHelper), new FermenterRecipeCategory(guiHelper), new RefineryRecipeCategory(guiHelper), ArcFurnaceRecipeCategory.getDefault(guiHelper), ArcFurnaceRecipeCategory.getRecycling(guiHelper), new BottlingMachineRecipeCategory(guiHelper), new MixerRecipeCategory(guiHelper)});
        slotDrawable = guiHelper.getSlotDrawable();
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IELogger.info("Adding recipes to JEI!!");
        registration.addRecipes(this.getRecipes(CokeOvenRecipe.RECIPES), CokeOvenRecipeCategory.UID);
        registration.addRecipes(this.getRecipes(AlloyRecipe.RECIPES), AlloySmelterRecipeCategory.UID);
        registration.addRecipes(this.getRecipes(BlastFurnaceRecipe.RECIPES), BlastFurnaceRecipeCategory.UID);
        registration.addRecipes(this.getRecipes(BlastFurnaceFuel.RECIPES), BlastFurnaceFuelCategory.UID);
        registration.addRecipes(this.getRecipes(ClocheRecipe.RECIPES), ClocheRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(MetalPressRecipe.STANDARD_RECIPES), IJEIRecipe::listInJEI), MetalPressRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(CrusherRecipe.RECIPES), IJEIRecipe::listInJEI), CrusherRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(SawmillRecipe.RECIPES), IJEIRecipe::listInJEI), SawmillRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(BlueprintCraftingRecipe.RECIPES), IJEIRecipe::listInJEI), WorkbenchRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(SqueezerRecipe.RECIPES), IJEIRecipe::listInJEI), SqueezerRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(FermenterRecipe.RECIPES), IJEIRecipe::listInJEI), FermenterRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(RefineryRecipe.RECIPES), IJEIRecipe::listInJEI), RefineryRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(ArcFurnaceRecipe.RECIPES), input -> input instanceof ArcRecyclingRecipe && input.listInJEI()), ArcFurnaceRecipeCategory.UID_RECYCLING);
        registration.addRecipes(Collections2.filter(this.getRecipes(ArcFurnaceRecipe.RECIPES), input -> !(input instanceof ArcRecyclingRecipe) && input.listInJEI()), ArcFurnaceRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(BottlingMachineRecipe.RECIPES), IJEIRecipe::listInJEI), BottlingMachineRecipeCategory.UID);
        registration.addRecipes(this.getFluidBucketRecipes(), BottlingMachineRecipeCategory.UID);
        registration.addRecipes(Collections2.filter(this.getRecipes(MixerRecipe.RECIPES), IJEIRecipe::listInJEI), MixerRecipeCategory.UID);
    }

    private <T extends Recipe<?>> Collection<T> getRecipes(CachedRecipeList<T> cachedList) {
        return cachedList.getRecipes((Level)Minecraft.m_91087_().f_91073_);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new AssemblerRecipeTransferHandler(registration.getTransferHelper()), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler(CraftingTableContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 54);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.ASSEMBLER), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.COKE_OVEN), new ResourceLocation[]{CokeOvenRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.ALLOY_SMELTER), new ResourceLocation[]{AlloySmelterRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.ADVANCED_BLAST_FURNACE), new ResourceLocation[]{BlastFurnaceRecipeCategory.UID, BlastFurnaceFuelCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.BLAST_FURNACE), new ResourceLocation[]{BlastFurnaceRecipeCategory.UID, BlastFurnaceFuelCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.MetalDevices.CLOCHE), new ResourceLocation[]{ClocheRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.METAL_PRESS), new ResourceLocation[]{MetalPressRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.CRUSHER), new ResourceLocation[]{CrusherRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.SAWMILL), new ResourceLocation[]{SawmillRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.WoodenDevices.WORKBENCH), new ResourceLocation[]{WorkbenchRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.AUTO_WORKBENCH), new ResourceLocation[]{WorkbenchRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.SQUEEZER), new ResourceLocation[]{SqueezerRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.FERMENTER), new ResourceLocation[]{FermenterRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.REFINERY), new ResourceLocation[]{RefineryRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.ARC_FURNACE), new ResourceLocation[]{ArcFurnaceRecipeCategory.UID, ArcFurnaceRecipeCategory.UID_RECYCLING});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.BOTTLING_MACHINE), new ResourceLocation[]{BottlingMachineRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack(IEBlocks.Multiblocks.MIXER), new ResourceLocation[]{MixerRecipeCategory.UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CokeOvenScreen.class, 58, 36, 11, 13, new ResourceLocation[]{CokeOvenRecipeCategory.UID});
        registration.addRecipeClickArea(AlloySmelterScreen.class, 84, 35, 22, 16, new ResourceLocation[]{AlloySmelterRecipeCategory.UID});
        registration.addRecipeClickArea(BlastFurnaceScreen.class, 76, 35, 22, 15, new ResourceLocation[]{BlastFurnaceRecipeCategory.UID, BlastFurnaceFuelCategory.UID});
        registration.addRecipeClickArea(SqueezerScreen.class, 90, 19, 20, 33, new ResourceLocation[]{SqueezerRecipeCategory.UID});
        registration.addRecipeClickArea(FermenterScreen.class, 90, 19, 20, 33, new ResourceLocation[]{FermenterRecipeCategory.UID});
        registration.addRecipeClickArea(RefineryScreen.class, 92, 24, 14, 20, new ResourceLocation[]{RefineryRecipeCategory.UID});
        registration.addRecipeClickArea(ArcFurnaceScreen.class, 81, 38, 23, 35, new ResourceLocation[]{ArcFurnaceRecipeCategory.UID, ArcFurnaceRecipeCategory.UID_RECYCLING});
        registration.addRecipeClickArea(MixerScreen.class, 52, 11, 16, 47, new ResourceLocation[]{MixerRecipeCategory.UID});
        registration.addRecipeClickArea(ModWorkbenchScreen.class, 4, 41, 53, 18, new ResourceLocation[]{WorkbenchRecipeCategory.UID});
        registration.addRecipeClickArea(AutoWorkbenchScreen.class, 90, 12, 39, 37, new ResourceLocation[]{WorkbenchRecipeCategory.UID});
        registration.addRecipeClickArea(CraftingTableScreen.class, 88, 31, 28, 23, new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addGhostIngredientHandler(IEContainerScreen.class, (IGhostIngredientHandler)new IEGhostItemHandler());
        registration.addGhostIngredientHandler(FluidSorterScreen.class, (IGhostIngredientHandler)new FluidSorterGhostHandler());
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    private ArrayList<BottlingMachineRecipe> getFluidBucketRecipes() {
        int fluidCount = ForgeRegistries.FLUIDS.getValues().size() / 2;
        ArrayList<BottlingMachineRecipe> recipes = new ArrayList<BottlingMachineRecipe>(fluidCount);
        for (Fluid f : ForgeRegistries.FLUIDS) {
            if (!f.m_7444_(f.m_76145_())) continue;
            Optional<ResourceLocation> tag = f.m_205069_().m_203616_().map(TagKey::f_203868_).min((o1, o2) -> {
                if (!"minecraft".equals(o1.m_135827_()) && !"forge".equals(o1.m_135827_())) {
                    return 1;
                }
                return -Long.compare(o1.m_135815_().codePoints().filter(ch -> ch == 47).count(), o2.m_135815_().codePoints().filter(ch -> ch == 47).count());
            });
            ItemStack bucket = f.m_6859_().m_7968_();
            if (bucket.m_41619_() || !tag.isPresent()) continue;
            recipes.add(new BottlingMachineRecipe(new ResourceLocation("immersiveengineering", "jei_bucket_" + f.getRegistryName().m_135815_()), (Lazy<ItemStack>)Lazy.of(() -> bucket), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42446_}), new FluidTagInput(tag.get(), 1000)));
        }
        return recipes;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    static {
        fluidTooltipCallback = new IEFluidTooltipCallback();
    }
}

