/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class DropInventoryLootEntry
extends LootPoolSingletonContainer {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "drop_inv");

    protected DropInventoryLootEntry(int weightIn, int qualityIn, LootItemCondition[] conditionsIn, LootItemFunction[] functionsIn) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
    }

    protected void m_6948_(@Nonnull Consumer<ItemStack> output, LootContext context) {
        if (context.m_78936_(LootContextParams.f_81462_)) {
            BlockEntity te = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
            if (te instanceof IEBlockInterfaces.IGeneralMultiblock) {
                BlockEntity masterTE = (BlockEntity)((IEBlockInterfaces.IGeneralMultiblock)te).master();
                boolean switchToMaster = true;
                if (masterTE instanceof MultiblockPartBlockEntity && masterTE.m_58904_() != null) {
                    boolean bl = switchToMaster = ((MultiblockPartBlockEntity)masterTE).onlyLocalDissassembly != masterTE.m_58904_().m_46467_();
                }
                if (switchToMaster) {
                    te = masterTE;
                }
            }
            if (te instanceof IIEInventory && ((IIEInventory)te).getDroppedItems() != null) {
                ((IIEInventory)te).getDroppedItems().forEach(output);
            } else if (te != null) {
                LazyOptional itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                itemHandler.ifPresent(h -> {
                    if (h instanceof IEInventoryHandler) {
                        for (int i = 0; i < h.getSlots(); ++i) {
                            if (h.getStackInSlot(i).m_41619_()) continue;
                            output.accept(h.getStackInSlot(i));
                            ((IEInventoryHandler)h).setStackInSlot(i, ItemStack.f_41583_);
                        }
                    }
                });
            }
        }
    }

    public static LootPoolSingletonContainer.Builder<?> builder() {
        return DropInventoryLootEntry.m_79687_(DropInventoryLootEntry::new);
    }

    @Nonnull
    public LootPoolEntryType m_6751_() {
        return IELootFunctions.dropInventory;
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<DropInventoryLootEntry> {
        @Nonnull
        protected DropInventoryLootEntry deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull LootItemCondition[] conditions, @Nonnull LootItemFunction[] functions) {
            return new DropInventoryLootEntry(weight, quality, conditions, functions);
        }
    }
}

