/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.particles.playerparticle;

import com.direwolf20.mininggadgets.client.particles.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class PlayerParticleData
implements ParticleOptions {
    public final float size;
    public final float r;
    public final float g;
    public final float b;
    public final float maxAgeMul;
    public final boolean depthTest;
    public final double targetX;
    public final double targetY;
    public final double targetZ;
    public final String partType;
    public static final ParticleOptions.Deserializer<PlayerParticleData> DESERIALIZER = new ParticleOptions.Deserializer<PlayerParticleData>(){

        @Nonnull
        public PlayerParticleData fromCommand(@Nonnull ParticleType<PlayerParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            String partType = reader.readString();
            reader.expect(' ');
            double targetX = reader.readDouble();
            reader.expect(' ');
            double targetY = reader.readDouble();
            reader.expect(' ');
            double targetZ = reader.readDouble();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float mam = reader.readFloat();
            boolean depth = true;
            if (reader.canRead()) {
                reader.expect(' ');
                depth = reader.readBoolean();
            }
            return new PlayerParticleData(partType, targetX, targetY, targetZ, size, r, g, b, mam, depth);
        }

        public PlayerParticleData fromNetwork(@Nonnull ParticleType<PlayerParticleData> type, FriendlyByteBuf buf) {
            return new PlayerParticleData(buf.m_130277_(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean());
        }
    };

    public static PlayerParticleData playerparticle(String type, double targetX, double targetY, double targetZ, float size, float r, float g, float b) {
        return PlayerParticleData.playerparticle(type, targetX, targetY, targetZ, size, r, g, b, 1.0f);
    }

    public static PlayerParticleData playerparticle(String type, double targetX, double targetY, double targetZ, float size, float r, float g, float b, float maxAgeMul) {
        return PlayerParticleData.playerparticle(type, targetX, targetY, targetZ, size, r, g, b, maxAgeMul, true);
    }

    public static PlayerParticleData playerparticle(String type, double targetX, double targetY, double targetZ, float size, float r, float g, float b, boolean depth) {
        return PlayerParticleData.playerparticle(type, targetX, targetY, targetZ, size, r, g, b, 1.0f, depth);
    }

    public static PlayerParticleData playerparticle(String type, double targetX, double targetY, double targetZ, float size, float r, float g, float b, float maxAgeMul, boolean depthTest) {
        return new PlayerParticleData(type, targetX, targetY, targetZ, size, r, g, b, maxAgeMul, depthTest);
    }

    private PlayerParticleData(String type, double targetX, double targetY, double targetZ, float size, float r, float g, float b, float maxAgeMul, boolean depthTest) {
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.size = size;
        this.r = r;
        this.g = g;
        this.b = b;
        this.maxAgeMul = maxAgeMul;
        this.depthTest = depthTest;
        this.partType = type;
    }

    @Nonnull
    public ParticleType<PlayerParticleData> m_6012_() {
        return ModParticles.PLAYERPARTICLE;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.m_130070_(this.partType);
        buf.writeDouble(this.targetX);
        buf.writeDouble(this.targetY);
        buf.writeDouble(this.targetZ);
        buf.writeFloat(this.size);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeFloat(this.maxAgeMul);
        buf.writeBoolean(this.depthTest);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s", this.m_6012_().getRegistryName(), Float.valueOf(this.size), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.maxAgeMul), this.depthTest);
    }
}

