/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.upgrade;

import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeI18n;

public class UpgradeTools {
    private static final String KEY_UPGRADES = "upgrades";
    private static final String KEY_UPGRADE = "upgrade";
    private static final String KEY_ENABLED = "enabled";

    private static void setUpgradeNBT(CompoundTag nbt, UpgradeCard upgrade) {
        ListTag list = nbt.m_128437_(KEY_UPGRADES, 10);
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(KEY_UPGRADE, upgrade.getUpgrade().getName());
        compound.m_128379_(KEY_ENABLED, upgrade.getUpgrade().isEnabled());
        list.add((Object)compound);
        nbt.m_128365_(KEY_UPGRADES, (Tag)list);
    }

    public static CompoundTag setUpgradesNBT(List<Upgrade> laserUpgrades) {
        CompoundTag listCompound = new CompoundTag();
        ListTag list = new ListTag();
        laserUpgrades.forEach(upgrade -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_(KEY_UPGRADE, upgrade.getName());
            compound.m_128379_(KEY_ENABLED, upgrade.isEnabled());
            list.add((Object)compound);
        });
        listCompound.m_128365_(KEY_UPGRADES, (Tag)list);
        return listCompound;
    }

    public static void setUpgrade(ItemStack tool, UpgradeCard upgrade) {
        CompoundTag tagCompound = tool.m_41784_();
        UpgradeTools.setUpgradeNBT(tagCompound, upgrade);
    }

    public static void updateUpgrade(ItemStack tool, Upgrade upgrade) {
        CompoundTag tagCompound = tool.m_41784_();
        ListTag list = tagCompound.m_128437_(KEY_UPGRADES, 10);
        list.forEach(e -> {
            CompoundTag compound = (CompoundTag)e;
            String name = compound.m_128461_(KEY_UPGRADE);
            boolean enabled = compound.m_128471_(KEY_ENABLED);
            if (name.contains(Upgrade.FORTUNE_1.getBaseName()) && enabled && upgrade.lazyIs(Upgrade.SILK) || name.equals(Upgrade.SILK.getBaseName()) && enabled && upgrade.lazyIs(Upgrade.FORTUNE_1)) {
                compound.m_128379_(KEY_ENABLED, false);
            }
            if (name.equals(upgrade.getName())) {
                compound.m_128379_(KEY_ENABLED, !compound.m_128471_(KEY_ENABLED));
            }
        });
    }

    public static List<Upgrade> getUpgradesFromTag(CompoundTag tagCompound) {
        ListTag upgrades = tagCompound.m_128437_(KEY_UPGRADES, 10);
        ArrayList<Upgrade> functionalUpgrades = new ArrayList<Upgrade>();
        if (upgrades.isEmpty()) {
            return functionalUpgrades;
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            CompoundTag tag = upgrades.m_128728_(i);
            Upgrade type = UpgradeTools.getUpgradeByName(tag.m_128461_(KEY_UPGRADE));
            if (type == null) continue;
            type.setEnabled(!tag.m_128441_(KEY_ENABLED) || tag.m_128471_(KEY_ENABLED));
            functionalUpgrades.add(type);
        }
        return functionalUpgrades;
    }

    public static List<Upgrade> getActiveUpgradesFromTag(CompoundTag tagCompound) {
        ListTag upgrades = tagCompound.m_128437_(KEY_UPGRADES, 10);
        ArrayList<Upgrade> functionalUpgrades = new ArrayList<Upgrade>();
        if (upgrades.isEmpty()) {
            return functionalUpgrades;
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            CompoundTag tag = upgrades.m_128728_(i);
            Upgrade type = UpgradeTools.getUpgradeByName(tag.m_128461_(KEY_UPGRADE));
            if (type == null) continue;
            type.setEnabled(!tag.m_128441_(KEY_ENABLED) || tag.m_128471_(KEY_ENABLED));
            if (!type.isEnabled()) continue;
            functionalUpgrades.add(type);
        }
        return functionalUpgrades;
    }

    @Nullable
    public static Upgrade getUpgradeByName(String name) {
        try {
            Upgrade type = Upgrade.valueOf(name.toUpperCase());
            return type;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static List<Upgrade> getUpgrades(ItemStack tool) {
        CompoundTag tagCompound = tool.m_41784_();
        return UpgradeTools.getUpgradesFromTag(tagCompound);
    }

    public static List<Upgrade> getActiveUpgrades(ItemStack tool) {
        CompoundTag tagCompound = tool.m_41784_();
        return UpgradeTools.getActiveUpgradesFromTag(tagCompound);
    }

    public static boolean containsUpgrades(ItemStack tool) {
        return tool.m_41784_().m_128441_(KEY_UPGRADES);
    }

    public static Optional<Upgrade> getUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        if (upgrades == null || upgrades.isEmpty()) {
            return Optional.empty();
        }
        return upgrades.stream().filter(upgrade -> upgrade.getBaseName().equals(type.getBaseName())).findFirst();
    }

    public static Optional<Upgrade> getUpgradeFromGadget(ItemStack tool, Upgrade type) {
        List<Upgrade> upgrades = UpgradeTools.getUpgrades(tool);
        return UpgradeTools.getUpgradeFromList(upgrades, type);
    }

    public static void removeUpgrade(ItemStack tool, Upgrade upgrade) {
        CompoundTag tagCompound = tool.m_41784_();
        ListTag upgrades = tagCompound.m_128437_(KEY_UPGRADES, 10);
        tagCompound.m_128365_(KEY_UPGRADES, (Tag)upgrades.stream().filter(e -> !((CompoundTag)e).m_128461_(KEY_UPGRADE).equals(upgrade.getName())).collect(Collectors.toCollection(ListTag::new)));
    }

    public static boolean containsUpgrade(ItemStack tool, Upgrade type) {
        return UpgradeTools.getUpgradeFromGadget(tool, type).isPresent();
    }

    public static boolean containsActiveUpgrade(ItemStack tool, Upgrade type) {
        Optional<Upgrade> upgrade = UpgradeTools.getUpgradeFromGadget(tool, type);
        return upgrade.isPresent() && upgrade.get().isEnabled();
    }

    public static boolean containsActiveUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        Optional<Upgrade> upgrade = UpgradeTools.getUpgradeFromList(upgrades, type);
        return upgrade.isPresent() && upgrade.get().isEnabled();
    }

    public static boolean containsUpgradeFromList(List<Upgrade> upgrades, Upgrade type) {
        return UpgradeTools.getUpgradeFromList(upgrades, type).isPresent();
    }

    public static int getMaxBeamRange(int tier) {
        return (tier + 1) * 5;
    }

    public static Component getName(Upgrade upgrade) {
        return new TextComponent(ForgeI18n.parseMessage((String)upgrade.getLocal(), (Object[])new Object[0]).replace(ForgeI18n.parseMessage((String)upgrade.getLocalReplacement(), (Object[])new Object[0]), ""));
    }
}

