/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryContraptionUpdatePacket;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftBlock;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class GantryContraptionEntity
extends AbstractContraptionEntity {
    Direction movementAxis;
    double clientOffsetDiff;
    double axisMotion;

    public GantryContraptionEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public static GantryContraptionEntity create(Level world, Contraption contraption, Direction movementAxis) {
        GantryContraptionEntity entity = new GantryContraptionEntity((EntityType)AllEntityTypes.GANTRY_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        entity.movementAxis = movementAxis;
        return entity;
    }

    @Override
    protected void tickContraption() {
        if (!(this.contraption instanceof GantryContraption)) {
            return;
        }
        double prevAxisMotion = this.axisMotion;
        if (this.f_19853_.f_46443_) {
            this.clientOffsetDiff *= 0.75;
            this.updateClientMotion();
        }
        this.checkPinionShaft();
        this.tickActors();
        Vec3 movementVec = this.m_20184_();
        if (ContraptionCollider.collideBlocks(this)) {
            if (!this.f_19853_.f_46443_) {
                this.disassemble();
            }
            return;
        }
        if (!this.isStalled() && this.f_19797_ > 2) {
            this.move(movementVec.f_82479_, movementVec.f_82480_, movementVec.f_82481_);
        }
        if (Math.signum(prevAxisMotion) != Math.signum(this.axisMotion) && prevAxisMotion != 0.0) {
            this.contraption.stop(this.f_19853_);
        }
        if (!(this.f_19853_.f_46443_ || prevAxisMotion == this.axisMotion && this.f_19797_ % 3 != 0)) {
            this.sendPacket();
        }
    }

    protected void checkPinionShaft() {
        Direction facing = ((GantryContraption)this.contraption).getFacing();
        Vec3 currentPosition = this.getAnchorVec().m_82520_(0.5, 0.5, 0.5);
        BlockPos gantryShaftPos = new BlockPos(currentPosition).m_142300_(facing.m_122424_());
        BlockEntity te = this.f_19853_.m_7702_(gantryShaftPos);
        if (!(te instanceof GantryShaftTileEntity) || !AllBlocks.GANTRY_SHAFT.has(te.m_58900_())) {
            if (!this.f_19853_.f_46443_) {
                this.setContraptionMotion(Vec3.f_82478_);
                this.disassemble();
            }
            return;
        }
        BlockState blockState = te.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)GantryShaftBlock.FACING);
        GantryShaftTileEntity gantryShaftTileEntity = (GantryShaftTileEntity)te;
        float pinionMovementSpeed = gantryShaftTileEntity.getPinionMovementSpeed();
        Vec3 movementVec = Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_((double)pinionMovementSpeed);
        if (((Boolean)blockState.m_61143_((Property)GantryShaftBlock.POWERED)).booleanValue() || pinionMovementSpeed == 0.0f) {
            this.setContraptionMotion(Vec3.f_82478_);
            if (!this.f_19853_.f_46443_) {
                this.disassemble();
            }
            return;
        }
        Vec3 nextPosition = currentPosition.m_82549_(movementVec);
        double currentCoord = direction.m_122434_().m_6150_(currentPosition.f_82479_, currentPosition.f_82480_, currentPosition.f_82481_);
        double nextCoord = direction.m_122434_().m_6150_(nextPosition.f_82479_, nextPosition.f_82480_, nextPosition.f_82481_);
        if ((double)((float)Mth.m_14107_((double)currentCoord) + 0.5f) < nextCoord != pinionMovementSpeed * (float)direction.m_122421_().m_122540_() < 0.0f && !gantryShaftTileEntity.canAssembleOn()) {
            this.setContraptionMotion(Vec3.f_82478_);
            if (!this.f_19853_.f_46443_) {
                this.disassemble();
            }
            return;
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.axisMotion = pinionMovementSpeed;
        this.setContraptionMotion(movementVec);
    }

    @Override
    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        NBTHelper.writeEnum(compound, "GantryAxis", this.movementAxis);
        super.writeAdditional(compound, spawnPacket);
    }

    @Override
    protected void readAdditional(CompoundTag compound, boolean spawnData) {
        this.movementAxis = NBTHelper.readEnum(compound, "GantryAxis", Direction.class);
        super.readAdditional(compound, spawnData);
    }

    @Override
    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        return localPos;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        return new StructureTransform(new BlockPos(this.getAnchorVec().m_82520_(0.5, 0.5, 0.5)), 0.0f, 0.0f, 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return 0.0f;
    }

    public void m_6021_(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yw, float pt, int inc, boolean t) {
    }

    @Override
    protected void handleStallInformation(float x, float y, float z, float angle) {
        this.m_20343_(x, y, z);
        this.clientOffsetDiff = 0.0;
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        return AbstractContraptionEntity.ContraptionRotationState.NONE;
    }

    @Override
    public void doLocalTransforms(float partialTicks, PoseStack[] matrixStacks) {
    }

    public void updateClientMotion() {
        float modifier = this.movementAxis.m_122421_().m_122540_();
        this.setContraptionMotion(Vec3.m_82528_((Vec3i)this.movementAxis.m_122436_()).m_82490_((this.axisMotion + this.clientOffsetDiff * (double)modifier / 2.0) * (double)ServerSpeedProvider.get()));
    }

    public double getAxisCoord() {
        Vec3 anchorVec = this.getAnchorVec();
        return this.movementAxis.m_122434_().m_6150_(anchorVec.f_82479_, anchorVec.f_82480_, anchorVec.f_82481_);
    }

    public void sendPacket() {
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new GantryContraptionUpdatePacket(this.m_142049_(), this.getAxisCoord(), this.axisMotion));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(GantryContraptionUpdatePacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (!(entity instanceof GantryContraptionEntity)) {
            return;
        }
        GantryContraptionEntity ce = (GantryContraptionEntity)entity;
        ce.axisMotion = packet.motion;
        ce.clientOffsetDiff = packet.coord - ce.getAxisCoord();
    }
}

