/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ContraptionMatrices {
    private final PoseStack modelViewProjection = new PoseStack();
    private final PoseStack viewProjection = new PoseStack();
    private final PoseStack model = new PoseStack();
    private final Matrix4f world = new Matrix4f();
    private final Matrix4f light = new Matrix4f();
    private boolean ready;

    public ContraptionMatrices() {
        this.world.m_27624_();
        this.light.m_27624_();
    }

    public void setup(PoseStack viewProjection, AbstractContraptionEntity entity) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        this.viewProjection.m_85836_();
        ContraptionMatrices.transform(this.viewProjection, viewProjection);
        this.model.m_85836_();
        entity.doLocalTransforms(partialTicks, new PoseStack[]{this.model});
        this.modelViewProjection.m_85836_();
        ContraptionMatrices.transform(this.modelViewProjection, viewProjection);
        ContraptionMatrices.transform(this.modelViewProjection, this.model);
        ContraptionMatrices.translateToEntity(this.world, entity, partialTicks);
        this.light.m_162210_(this.world);
        this.light.m_27644_(this.model.m_85850_().m_85861_());
        this.ready = true;
    }

    public void clear() {
        ContraptionMatrices.clearStack(this.modelViewProjection);
        ContraptionMatrices.clearStack(this.viewProjection);
        ContraptionMatrices.clearStack(this.model);
        this.world.m_27624_();
        this.light.m_27624_();
        this.ready = false;
    }

    public PoseStack getModelViewProjection() {
        return this.modelViewProjection;
    }

    public PoseStack getViewProjection() {
        return this.viewProjection;
    }

    public PoseStack getModel() {
        return this.model;
    }

    public Matrix4f getWorld() {
        return this.world;
    }

    public Matrix4f getLight() {
        return this.light;
    }

    public boolean isReady() {
        return this.ready;
    }

    public static void transform(PoseStack ms, PoseStack transform) {
        ms.m_85850_().m_85861_().m_27644_(transform.m_85850_().m_85861_());
        ms.m_85850_().m_85864_().m_8178_(transform.m_85850_().m_85864_());
    }

    public static void translateToEntity(Matrix4f matrix, Entity entity, float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        matrix.setTranslation((float)x, (float)y, (float)z);
    }

    public static void clearStack(PoseStack ms) {
        while (!ms.m_85851_()) {
            ms.m_85849_();
        }
    }
}

