/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.StraightPipeTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class FluidValveTileEntity
extends KineticTileEntity {
    LerpedFloat pointer = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);

    public FluidValveTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        this.pointer.chase(speed > 0.0f ? 1.0 : 0.0, this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.pointer.tickChaser();
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof FluidValveBlock)) {
            return;
        }
        boolean stateOpen = (Boolean)blockState.m_61143_((Property)FluidValveBlock.ENABLED);
        if (stateOpen && this.pointer.getValue() == 0.0f) {
            FluidValveTileEntity.switchToBlockState(this.f_58857_, this.f_58858_, (BlockState)blockState.m_61124_((Property)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        if (!stateOpen && this.pointer.getValue() == 1.0f) {
            FluidValveTileEntity.switchToBlockState(this.f_58857_, this.f_58858_, (BlockState)blockState.m_61124_((Property)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(true)));
            return;
        }
    }

    private float getChaseSpeed() {
        return Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 16.0f / 20.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Pointer", (Tag)this.pointer.writeNBT());
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.pointer.readNBT(compound.m_128469_("Pointer"), clientPacket);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new ValvePipeBehaviour(this));
    }

    class ValvePipeBehaviour
    extends StraightPipeTileEntity.StraightPipeFluidTransportBehaviour {
        public ValvePipeBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return FluidValveBlock.getPipeAxis(state) == direction.m_122434_();
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, BlockState state, Direction direction) {
            if (state.m_61138_((Property)FluidValveBlock.ENABLED) && ((Boolean)state.m_61143_((Property)FluidValveBlock.ENABLED)).booleanValue()) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }
    }
}

