/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.simibubi.create.foundation.utility.Lang;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IHaveGoggleInformation {
    public static final Format numberFormat = new Format();
    public static final String spacing = "    ";
    public static final Component componentSpacing = new TextComponent("    ");

    default public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public static String format(double d) {
        return numberFormat.get().format(d).replace("\u00a0", " ");
    }

    default public boolean containedFluidTooltip(List<Component> tooltip, boolean isPlayerSneaking, LazyOptional<IFluidHandler> handler) {
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("gui.goggles.fluid_container", new Object[0])));
        TranslatableComponent mb = Lang.translate("generic.unit.millibuckets", new Object[0]);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        TextComponent indent = new TextComponent("     ");
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            MutableComponent fluidName = new TranslatableComponent(fluidStack.getTranslationKey()).m_130940_(ChatFormatting.GRAY);
            MutableComponent contained = new TextComponent(IHaveGoggleInformation.format(fluidStack.getAmount())).m_7220_((Component)mb).m_130940_(ChatFormatting.GOLD);
            MutableComponent slash = new TextComponent(" / ").m_130940_(ChatFormatting.GRAY);
            MutableComponent capacity = new TextComponent(IHaveGoggleInformation.format(tank.getTankCapacity(i))).m_7220_((Component)mb).m_130940_(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)indent.m_6879_().m_7220_((Component)fluidName));
            tooltip.add((Component)indent.m_6879_().m_7220_((Component)contained).m_7220_((Component)slash).m_7220_((Component)capacity));
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        MutableComponent capacity = Lang.translate("gui.goggles.fluid_container.capacity", new Object[0]).m_130940_(ChatFormatting.GRAY);
        MutableComponent amount = new TextComponent(IHaveGoggleInformation.format(tank.getTankCapacity(0))).m_7220_((Component)mb).m_130940_(ChatFormatting.GOLD);
        tooltip.add((Component)indent.m_6879_().m_7220_((Component)capacity).m_7220_((Component)amount));
        return true;
    }

    public static class Format {
        private NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);

        private Format() {
        }

        public NumberFormat get() {
            return this.format;
        }

        public void update() {
            this.format = NumberFormat.getInstance(Minecraft.m_91087_().m_91102_().m_118983_().getJavaLocale());
            this.format.setMaximumFractionDigits(2);
            this.format.setMinimumFractionDigits(0);
            this.format.setGroupingUsed(true);
        }
    }
}

