/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BracketedTileEntityBehaviour
extends TileEntityBehaviour {
    public static final BehaviourType<BracketedTileEntityBehaviour> TYPE = new BehaviourType();
    private Optional<BlockState> bracket;
    private boolean reRender;
    private Predicate<BlockState> pred;
    private Function<BlockState, ITriggerable> trigger;

    public BracketedTileEntityBehaviour(SmartTileEntity te) {
        this(te, state -> true);
    }

    public BracketedTileEntityBehaviour(SmartTileEntity te, Predicate<BlockState> pred) {
        super(te);
        this.pred = pred;
        this.bracket = Optional.empty();
    }

    public BracketedTileEntityBehaviour withTrigger(Function<BlockState, ITriggerable> trigger) {
        this.trigger = trigger;
        return this;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void applyBracket(BlockState state) {
        this.bracket = Optional.of(state);
        this.reRender = true;
        this.tileEntity.notifyUpdate();
    }

    public void transformBracket(StructureTransform transform) {
        if (this.isBracketPresent()) {
            BlockState bracket = this.getBracket();
            BlockState transformedBracket = transform.apply(bracket);
            this.applyBracket(transformedBracket);
        }
    }

    public void removeBracket(boolean inOnReplacedContext) {
        Level world = this.getWorld();
        if (!world.f_46443_) {
            world.m_46796_(2001, this.getPos(), Block.m_49956_((BlockState)this.getBracket()));
        }
        this.bracket = Optional.empty();
        this.reRender = true;
        if (inOnReplacedContext) {
            this.tileEntity.sendData();
        } else {
            this.tileEntity.notifyUpdate();
        }
    }

    public boolean isBracketPresent() {
        return this.bracket.isPresent();
    }

    public BlockState getBracket() {
        return this.bracket.orElse(Blocks.f_50016_.m_49966_());
    }

    public boolean canHaveBracket() {
        return this.pred.test(this.tileEntity.m_58900_());
    }

    public void triggerAdvancements(Level world, Player player, BlockState state) {
        if (this.trigger == null) {
            return;
        }
        AllTriggers.triggerFor(this.trigger.apply(state), player);
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return ItemRequirement.of(this.getBracket(), null);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        this.bracket.ifPresent(p -> nbt.m_128365_("Bracket", (Tag)NbtUtils.m_129202_((BlockState)p)));
        if (clientPacket && this.reRender) {
            NBTHelper.putMarker(nbt, "Redraw");
            this.reRender = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        this.bracket = Optional.empty();
        if (nbt.m_128441_("Bracket")) {
            this.bracket = Optional.of(NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("Bracket")));
        }
        if (clientPacket && nbt.m_128441_("Redraw")) {
            this.getWorld().m_7260_(this.getPos(), this.tileEntity.m_58900_(), this.tileEntity.m_58900_(), 16);
        }
        super.read(nbt, clientPacket);
    }
}

