/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.InterpolatedChasingAngle;
import com.simibubi.create.foundation.utility.animation.InterpolatedChasingValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SchematicTransformation {
    private InterpolatedChasingValue x = new InterpolatedChasingValue();
    private InterpolatedChasingValue y = new InterpolatedChasingValue();
    private InterpolatedChasingValue z = new InterpolatedChasingValue();
    private InterpolatedChasingValue scaleFrontBack = new InterpolatedChasingValue();
    private InterpolatedChasingValue scaleLeftRight = new InterpolatedChasingValue();
    private InterpolatedChasingAngle rotation = new InterpolatedChasingAngle();
    private double xOrigin;
    private double zOrigin;

    public void init(BlockPos anchor, StructurePlaceSettings settings, AABB bounds) {
        int leftRight = settings.m_74401_() == Mirror.LEFT_RIGHT ? -1 : 1;
        int frontBack = settings.m_74401_() == Mirror.FRONT_BACK ? -1 : 1;
        this.getScaleFB().start(frontBack);
        this.getScaleLR().start(leftRight);
        this.xOrigin = bounds.m_82362_() / 2.0;
        this.zOrigin = bounds.m_82385_() / 2.0;
        int r = -(settings.m_74404_().ordinal() * 90);
        this.rotation.start(r);
        Vec3 vec = this.fromAnchor(anchor);
        this.x.start((float)vec.f_82479_);
        this.y.start((float)vec.f_82480_);
        this.z.start((float)vec.f_82481_);
    }

    public void applyGLTransformations(PoseStack ms) {
        float pt = AnimationTickHolder.getPartialTicks();
        ms.m_85837_((double)this.x.get(pt), (double)this.y.get(pt), (double)this.z.get(pt));
        Vec3 rotationOffset = this.getRotationOffset(true);
        float fb = this.getScaleFB().get(pt);
        float lr = this.getScaleLR().get(pt);
        float rot = this.rotation.get(pt) + (float)(fb < 0.0f && lr < 0.0f ? 180 : 0);
        ms.m_85837_(this.xOrigin, 0.0, this.zOrigin);
        ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).translate(rotationOffset)).rotateY((double)rot)).translateBack(rotationOffset);
        ms.m_85841_(Math.abs(fb), 1.0f, Math.abs(lr));
        ms.m_85837_(-this.xOrigin, 0.0, -this.zOrigin);
    }

    public boolean isFlipped() {
        return this.getMirrorModifier(Direction.Axis.X) < 0 != this.getMirrorModifier(Direction.Axis.Z) < 0;
    }

    public Vec3 getRotationOffset(boolean ignoreMirrors) {
        Vec3 rotationOffset = Vec3.f_82478_;
        if ((int)(this.zOrigin * 2.0) % 2 != (int)(this.xOrigin * 2.0) % 2) {
            float zIn;
            boolean xGreaterZ = this.xOrigin > this.zOrigin;
            float xIn = xGreaterZ ? 0.0f : 0.5f;
            float f = zIn = !xGreaterZ ? 0.0f : 0.5f;
            if (!ignoreMirrors) {
                xIn *= (float)this.getMirrorModifier(Direction.Axis.X);
                zIn *= (float)this.getMirrorModifier(Direction.Axis.Z);
            }
            rotationOffset = new Vec3((double)xIn, 0.0, (double)zIn);
        }
        return rotationOffset;
    }

    public Vec3 toLocalSpace(Vec3 vec) {
        float pt = AnimationTickHolder.getPartialTicks();
        Vec3 rotationOffset = this.getRotationOffset(true);
        vec = vec.m_82492_((double)this.x.get(pt), (double)this.y.get(pt), (double)this.z.get(pt));
        vec = vec.m_82492_(this.xOrigin + rotationOffset.f_82479_, 0.0, this.zOrigin + rotationOffset.f_82481_);
        vec = VecHelper.rotate(vec, -this.rotation.get(pt), Direction.Axis.Y);
        vec = vec.m_82520_(rotationOffset.f_82479_, 0.0, rotationOffset.f_82481_);
        vec = vec.m_82542_((double)this.getScaleFB().get(pt), 1.0, (double)this.getScaleLR().get(pt));
        vec = vec.m_82520_(this.xOrigin, 0.0, this.zOrigin);
        return vec;
    }

    public StructurePlaceSettings toSettings() {
        boolean mirrorfb;
        StructurePlaceSettings settings = new StructurePlaceSettings();
        int i = (int)this.rotation.getTarget();
        boolean mirrorlr = this.getScaleLR().getTarget() < 0.0f;
        boolean bl = mirrorfb = this.getScaleFB().getTarget() < 0.0f;
        if (mirrorlr && mirrorfb) {
            mirrorfb = false;
            mirrorlr = false;
            i += 180;
        }
        if ((i %= 360) < 0) {
            i += 360;
        }
        Rotation rotation = Rotation.NONE;
        switch (i) {
            case 90: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case 180: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case 270: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
        }
        settings.m_74379_(rotation);
        if (mirrorfb) {
            settings.m_74377_(Mirror.FRONT_BACK);
        }
        if (mirrorlr) {
            settings.m_74377_(Mirror.LEFT_RIGHT);
        }
        return settings;
    }

    public BlockPos getAnchor() {
        Vec3 vec = Vec3.f_82478_.m_82520_(0.5, 0.0, 0.5);
        Vec3 rotationOffset = this.getRotationOffset(false);
        vec = vec.m_82492_(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.m_82492_(rotationOffset.f_82479_, 0.0, rotationOffset.f_82481_);
        vec = vec.m_82542_((double)this.getScaleFB().getTarget(), 1.0, (double)this.getScaleLR().getTarget());
        vec = VecHelper.rotate(vec, this.rotation.getTarget(), Direction.Axis.Y);
        vec = vec.m_82520_(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.m_82520_((double)this.x.getTarget(), (double)this.y.getTarget(), (double)this.z.getTarget());
        return new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public Vec3 fromAnchor(BlockPos pos) {
        Vec3 vec = Vec3.f_82478_.m_82520_(0.5, 0.0, 0.5);
        Vec3 rotationOffset = this.getRotationOffset(false);
        vec = vec.m_82492_(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.m_82492_(rotationOffset.f_82479_, 0.0, rotationOffset.f_82481_);
        vec = vec.m_82542_((double)this.getScaleFB().getTarget(), 1.0, (double)this.getScaleLR().getTarget());
        vec = VecHelper.rotate(vec, this.rotation.getTarget(), Direction.Axis.Y);
        vec = vec.m_82520_(this.xOrigin, 0.0, this.zOrigin);
        return Vec3.m_82528_((Vec3i)pos.m_141950_((Vec3i)new BlockPos(vec.f_82479_, vec.f_82480_, vec.f_82481_)));
    }

    public int getRotationTarget() {
        return (int)this.rotation.getTarget();
    }

    public int getMirrorModifier(Direction.Axis axis) {
        if (axis == Direction.Axis.Z) {
            return (int)this.getScaleLR().getTarget();
        }
        return (int)this.getScaleFB().getTarget();
    }

    public float getCurrentRotation() {
        float pt = AnimationTickHolder.getPartialTicks();
        return this.rotation.get(pt);
    }

    public void tick() {
        this.x.tick();
        this.y.tick();
        this.z.tick();
        this.getScaleLR().tick();
        this.getScaleFB().tick();
        this.rotation.tick();
    }

    public void flip(Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            this.getScaleLR().target(this.getScaleLR().getTarget() * -1.0f);
        }
        if (axis == Direction.Axis.Z) {
            this.getScaleFB().target(this.getScaleFB().getTarget() * -1.0f);
        }
    }

    public void rotate90(boolean clockwise) {
        this.rotation.target(this.rotation.getTarget() + (float)(clockwise ? -90 : 90));
    }

    public void move(float xIn, float yIn, float zIn) {
        this.moveTo(this.x.getTarget() + xIn, this.y.getTarget() + yIn, this.z.getTarget() + zIn);
    }

    public void startAt(BlockPos pos) {
        this.x.start(pos.m_123341_());
        this.y.start(0.0f);
        this.z.start(pos.m_123343_());
        this.moveTo(pos);
    }

    public void moveTo(BlockPos pos) {
        this.moveTo(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public void moveTo(float xIn, float yIn, float zIn) {
        this.x.target(xIn);
        this.y.target(yIn);
        this.z.target(zIn);
    }

    public InterpolatedChasingValue getScaleFB() {
        return this.scaleFrontBack;
    }

    public InterpolatedChasingValue getScaleLR() {
        return this.scaleLeftRight;
    }
}

