/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.FurnaceEngineBlock;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelBlock;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CKinetics;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class ItemDescription {
    public static final ItemDescription MISSING = new ItemDescription(null);
    public static Component trim = new TextComponent("                          ").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.STRIKETHROUGH});
    private List<Component> lines;
    private List<Component> linesOnShift;
    private List<Component> linesOnCtrl;
    private Palette palette;

    public ItemDescription(Palette palette) {
        this.palette = palette;
        this.lines = new ArrayList<Component>();
        this.linesOnShift = new ArrayList<Component>();
        this.linesOnCtrl = new ArrayList<Component>();
    }

    public ItemDescription withSummary(Component summary) {
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutTextComponent(summary, this.palette.color, this.palette.hColor));
        return this;
    }

    public static List<Component> getKineticStats(Block block) {
        MutableComponent level;
        int index;
        IRotate.StressImpact impactId;
        boolean hasStressCapacity;
        boolean showStressImpact;
        IRotate.SpeedLevel minimumRequiredSpeedLevel;
        ArrayList<Component> list = new ArrayList<Component>();
        CKinetics config = AllConfigs.SERVER.kinetics;
        TranslatableComponent rpmUnit = Lang.translate("generic.unit.rpm", new Object[0]);
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)Minecraft.m_91087_().f_91074_);
        if (!(block instanceof IRotate)) {
            minimumRequiredSpeedLevel = IRotate.SpeedLevel.NONE;
            showStressImpact = true;
        } else {
            minimumRequiredSpeedLevel = ((IRotate)block).getMinimumRequiredSpeedLevel();
            showStressImpact = !((IRotate)block).hideStressImpact();
        }
        boolean hasSpeedRequirement = minimumRequiredSpeedLevel != IRotate.SpeedLevel.NONE && minimumRequiredSpeedLevel != IRotate.SpeedLevel.SLOW;
        boolean hasStressImpact = IRotate.StressImpact.isEnabled() && showStressImpact && BlockStressValues.getImpact(block) > 0.0;
        boolean bl = hasStressCapacity = IRotate.StressImpact.isEnabled() && BlockStressValues.hasCapacity(block);
        if (hasSpeedRequirement) {
            int index2 = minimumRequiredSpeedLevel.ordinal();
            MutableComponent level2 = new TextComponent(ItemDescription.makeProgressBar(3, index2)).m_130940_(minimumRequiredSpeedLevel.getTextColor());
            if (hasGoggles) {
                level2.m_130946_(String.valueOf(minimumRequiredSpeedLevel.getSpeedValue())).m_7220_((Component)rpmUnit).m_130946_("+");
            } else {
                level2.m_7220_((Component)Lang.translate("tooltip.speedRequirement." + Lang.asId(minimumRequiredSpeedLevel.name()), new Object[0]));
            }
            list.add((Component)Lang.translate("tooltip.speedRequirement", new Object[0]).m_130940_(ChatFormatting.GRAY));
            list.add((Component)level2);
        }
        if (hasStressImpact) {
            double impact = BlockStressValues.getImpact(block);
            impactId = impact >= (Double)config.highStressImpact.get() ? IRotate.StressImpact.HIGH : (impact >= (Double)config.mediumStressImpact.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            index = impactId.ordinal();
            level = new TextComponent(ItemDescription.makeProgressBar(3, index + 1)).m_130940_(impactId.getAbsoluteColor());
            if (hasGoggles) {
                level.m_130946_(impact + "x ").m_7220_((Component)rpmUnit);
            } else {
                level.m_7220_((Component)Lang.translate("tooltip.stressImpact." + Lang.asId(impactId.name()), new Object[0]));
            }
            list.add((Component)Lang.translate("tooltip.stressImpact", new Object[0]).m_130940_(ChatFormatting.GRAY));
            list.add((Component)level);
        }
        if (hasStressCapacity) {
            double capacity = BlockStressValues.getCapacity(block);
            impactId = capacity >= (Double)config.highCapacity.get() ? IRotate.StressImpact.LOW : (capacity >= (Double)config.mediumCapacity.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.HIGH);
            index = IRotate.StressImpact.values().length - 2 - impactId.ordinal();
            level = new TextComponent(ItemDescription.makeProgressBar(3, index + 1)).m_130940_(impactId.getAbsoluteColor());
            if (hasGoggles) {
                level.m_130946_(capacity + "x ").m_7220_((Component)rpmUnit);
            } else {
                level.m_7220_((Component)Lang.translate("tooltip.capacityProvided." + Lang.asId(impactId.name()), new Object[0]));
            }
            list.add((Component)Lang.translate("tooltip.capacityProvided", new Object[0]).m_130940_(ChatFormatting.GRAY));
            list.add((Component)level);
            MutableComponent genSpeed = ItemDescription.generatorSpeed(block, (Component)rpmUnit);
            if (!genSpeed.getString().isEmpty()) {
                list.add((Component)new TextComponent(" ").m_7220_((Component)genSpeed).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        return list;
    }

    public static String makeProgressBar(int length, int filledLength) {
        int i;
        Object bar = " ";
        int emptySpaces = length - filledLength;
        for (i = 0; i < filledLength; ++i) {
            bar = (String)bar + "\u2588";
        }
        for (i = 0; i < emptySpaces; ++i) {
            bar = (String)bar + "\u2592";
        }
        return (String)bar + " ";
    }

    public ItemDescription withBehaviour(String condition, String behaviour) {
        ItemDescription.add(this.linesOnShift, (Component)new TextComponent(condition).m_130940_(ChatFormatting.GRAY));
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutStringTextComponent(behaviour, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription withControl(String condition, String action) {
        ItemDescription.add(this.linesOnCtrl, (Component)new TextComponent(condition).m_130940_(ChatFormatting.GRAY));
        ItemDescription.addStrings(this.linesOnCtrl, TooltipHelper.cutStringTextComponent(action, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription createTabs() {
        boolean hasControls;
        boolean hasDescription = !this.linesOnShift.isEmpty();
        boolean bl = hasControls = !this.linesOnCtrl.isEmpty();
        if (hasDescription || hasControls) {
            String[] holdDesc = Lang.translate("tooltip.holdForDescription", "$").getString().split("\\$");
            String[] holdCtrl = Lang.translate("tooltip.holdForControls", "$").getString().split("\\$");
            TranslatableComponent keyShift = Lang.translate("tooltip.keyShift", new Object[0]);
            TranslatableComponent keyCtrl = Lang.translate("tooltip.keyCtrl", new Object[0]);
            for (List list : Arrays.asList(this.lines, this.linesOnShift, this.linesOnCtrl)) {
                TextComponent tabBuilder;
                boolean ctrl;
                boolean shift = list == this.linesOnShift;
                boolean bl2 = ctrl = list == this.linesOnCtrl;
                if (holdDesc.length != 2 || holdCtrl.length != 2) {
                    list.add(0, new TextComponent("Invalid lang formatting!"));
                    continue;
                }
                if (hasControls) {
                    tabBuilder = new TextComponent("");
                    tabBuilder.m_7220_((Component)new TextComponent(holdCtrl[0]).m_130940_(ChatFormatting.DARK_GRAY));
                    tabBuilder.m_7220_((Component)keyCtrl.m_6879_().m_130940_(ctrl ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    tabBuilder.m_7220_((Component)new TextComponent(holdCtrl[1]).m_130940_(ChatFormatting.DARK_GRAY));
                    list.add(0, tabBuilder);
                }
                if (hasDescription) {
                    tabBuilder = new TextComponent("");
                    tabBuilder.m_7220_((Component)new TextComponent(holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
                    tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(shift ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                    tabBuilder.m_7220_((Component)new TextComponent(holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
                    list.add(0, tabBuilder);
                }
                if (!shift && !ctrl) continue;
                list.add(hasDescription && hasControls ? 2 : 1, new TextComponent(""));
            }
        }
        if (!hasDescription) {
            this.linesOnShift = this.lines;
        }
        if (!hasControls) {
            this.linesOnCtrl = this.lines;
        }
        return this;
    }

    public static String hightlight(String s, Palette palette) {
        return palette.hColor + s + palette.color;
    }

    public static void addStrings(List<Component> infoList, List<Component> textLines) {
        textLines.forEach(s -> ItemDescription.add(infoList, s));
    }

    public static void add(List<Component> infoList, List<Component> textLines) {
        infoList.addAll(textLines);
    }

    public static void add(List<Component> infoList, Component line) {
        infoList.add(line);
    }

    public Palette getPalette() {
        return this.palette;
    }

    public List<Component> addInformation(List<Component> tooltip) {
        if (Screen.m_96638_()) {
            tooltip.addAll(this.linesOnShift);
            return tooltip;
        }
        if (Screen.m_96637_()) {
            tooltip.addAll(this.linesOnCtrl);
            return tooltip;
        }
        tooltip.addAll(this.lines);
        return tooltip;
    }

    public List<Component> getLines() {
        return this.lines;
    }

    public List<Component> getLinesOnCtrl() {
        return this.linesOnCtrl;
    }

    public List<Component> getLinesOnShift() {
        return this.linesOnShift;
    }

    private static MutableComponent generatorSpeed(Block block, Component unitRPM) {
        Object value = "";
        if (block instanceof WaterWheelBlock) {
            int baseSpeed = (Integer)AllConfigs.SERVER.kinetics.waterWheelBaseSpeed.get();
            int speedmod = (Integer)AllConfigs.SERVER.kinetics.waterWheelFlowSpeed.get();
            value = speedmod + baseSpeed + "-" + (baseSpeed + speedmod * 3);
        } else if (block instanceof EncasedFanBlock) {
            value = ((Integer)AllConfigs.SERVER.kinetics.generatingFanSpeed.get()).toString();
        } else if (block instanceof FurnaceEngineBlock) {
            int baseSpeed = (Integer)AllConfigs.SERVER.kinetics.furnaceEngineSpeed.get();
            value = baseSpeed + "-" + baseSpeed * 2;
        }
        return !((String)value).equals("") ? Lang.translate("tooltip.generationSpeed", value, unitRPM) : TextComponent.f_131282_.m_6879_();
    }

    public static enum Palette {
        Blue(ChatFormatting.BLUE, ChatFormatting.AQUA),
        Green(ChatFormatting.DARK_GREEN, ChatFormatting.GREEN),
        Yellow(ChatFormatting.GOLD, ChatFormatting.YELLOW),
        Red(ChatFormatting.DARK_RED, ChatFormatting.RED),
        Purple(ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE),
        Gray(ChatFormatting.DARK_GRAY, ChatFormatting.GRAY);

        public ChatFormatting color;
        public ChatFormatting hColor;

        private Palette(ChatFormatting primary, ChatFormatting highlight) {
            this.color = primary;
            this.hColor = highlight;
        }
    }
}

