/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class PonderTagScreen
extends NavigatableSimiScreen {
    public static final String ASSOCIATED = "ponder.associated";
    private final PonderTag tag;
    protected final List<Item> items;
    private final double itemXmult = 0.5;
    protected Rect2i itemArea;
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    protected Rect2i chapterArea;
    private final double mainYmult = 0.15;
    private ItemStack hoveredItem = ItemStack.f_41583_;

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
        this.items = new ArrayList<Item>();
        this.chapters = new ArrayList<PonderChapter>();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.items.clear();
        PonderRegistry.TAGS.getItems(this.tag).stream().map(key -> {
            Block b;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
            if (item == null && (b = (Block)ForgeRegistries.BLOCKS.getValue(key)) != null) {
                item = b.m_5456_();
            }
            return item;
        }).filter(Objects::nonNull).forEach(this.items::add);
        if (!this.tag.getMainItem().m_41619_()) {
            this.items.remove(this.tag.getMainItem().m_41720_());
        }
        int rowCount = Mth.m_14045_((int)((int)Math.ceil((double)this.items.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.items.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.f_96543_ * 0.5);
        int itemCenterY = this.getItemsY();
        for (Item i : this.items) {
            Object b = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new ItemStack((ItemLike)i));
            if (PonderRegistry.ALL.containsKey(i.getRegistryName())) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(new ItemStack((ItemLike)i), this.tag));
                });
            } else if (i.getRegistryName().m_135827_().equals("create")) {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_CREATE))).animateColors(false);
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_VANILLA))).animateColors(false);
            }
            this.m_142416_((GuiEventListener)b);
            layout.next();
        }
        if (!this.tag.getMainItem().m_41619_()) {
            ResourceLocation registryName = this.tag.getMainItem().m_41720_().getRegistryName();
            Object b = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 42, itemCenterY - 10).showing(this.tag.getMainItem());
            if (PonderRegistry.ALL.containsKey(registryName)) {
                ((AbstractSimiWidget)b).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(this.tag.getMainItem(), this.tag));
                });
            } else if (registryName.m_135827_().equals("create")) {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_CREATE))).animateColors(false);
            } else {
                ((BoxWidget)((BoxWidget)b).withBorderColors(Theme.p(Theme.Key.PONDER_MISSING_VANILLA))).animateColors(false);
            }
            this.m_142416_((GuiEventListener)b);
        }
        this.chapters.clear();
        this.chapters.addAll(PonderRegistry.TAGS.getChapters(this.tag));
        rowCount = Mth.m_14045_((int)((int)Math.ceil((float)this.chapters.size() / 3.0f)), (int)1, (int)3);
        layout = LayoutHelper.centeredHorizontal(this.chapters.size(), rowCount, 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.f_96543_ * 0.5);
        int chapterCenterY = (int)((double)this.f_96544_ * 0.75);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.m_142416_(label);
            layout.next();
        }
    }

    @Override
    protected void initBackTrackIcon(PonderButton backTrack) {
        backTrack.showing(this.tag);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.f_41583_;
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        for (GuiEventListener child : this.m_6702_()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).m_5953_(mouseX, mouseY)) continue;
            this.hoveredItem = button.getItem();
        }
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.renderItems(ms, mouseX, mouseY, partialTicks);
        this.renderChapters(ms, mouseX, mouseY, partialTicks);
        ms.m_85836_();
        ms.m_85837_((double)(this.f_96543_ / 2 - 120), (double)this.f_96544_ * 0.15 - 40.0, 0.0);
        ms.m_85836_();
        int x = 59;
        int y = 31;
        String title = this.tag.getTitle();
        int streakHeight = 35;
        UIRenderHelper.streak(ms, 0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(21.0f, 21.0f, 100.0f)).withBounds(30, 30)).render(ms);
        this.f_96547_.m_92889_(ms, (Component)Lang.translate("ponder.pondering", new Object[0]), (float)x, (float)(y - 6), Theme.i(Theme.Key.TEXT_DARKER));
        ms.m_85837_((double)(x += 0), (double)(y += 8), 0.0);
        ms.m_85837_(0.0, 0.0, 5.0);
        this.f_96547_.m_92883_(ms, title, 0.0f, 0.0f, Theme.i(Theme.Key.TEXT));
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85837_(23.0, 23.0, 10.0);
        ms.m_85841_(1.66f, 1.66f, 1.66f);
        this.tag.render(ms, 0, 0);
        ms.m_85849_();
        ms.m_85849_();
        ms.m_85836_();
        int w = (int)((double)this.f_96543_ * 0.45);
        x = (this.f_96543_ - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.m_110091_(), 48);
        String desc = this.tag.getDescription();
        int h = this.f_96547_.m_92920_(desc, w);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at(x - 3, y - 3, 90.0f)).withBounds(w + 6, h + 6)).render(ms);
        ms.m_85837_(0.0, 0.0, 100.0);
        FontHelper.drawSplitString(ms, this.f_96547_, desc, x, y, w, Theme.i(Theme.Key.TEXT));
        ms.m_85849_();
    }

    protected void renderItems(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.items.isEmpty()) {
            return;
        }
        int x = (int)((double)this.f_96543_ * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Lang.translate(ASSOCIATED, new Object[0]).getString();
        int stringWidth = this.f_96547_.m_92895_(relatedTitle);
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 0.0);
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(Theme.c(Theme.Key.PONDER_BACKGROUND_FLAT))).gradientBorder(Theme.p(Theme.Key.PONDER_IDLE))).at((float)(this.windowWidth - stringWidth) / 2.0f - 5.0f, this.itemArea.m_110086_() - 21, 100.0f)).withBounds(stringWidth + 10, 10)).render(ms);
        ms.m_85837_(0.0, 0.0, 200.0);
        PonderTagScreen.m_93208_((PoseStack)ms, (Font)this.f_96547_, (String)relatedTitle, (int)(this.windowWidth / 2), (int)(this.itemArea.m_110086_() - 20), (int)Theme.i(Theme.Key.TEXT));
        ms.m_85837_(0.0, 0.0, -200.0);
        UIRenderHelper.streak(ms, 0.0f, 0, 0, this.itemArea.m_110091_() + 10, this.itemArea.m_110090_() / 2 + 75);
        UIRenderHelper.streak(ms, 180.0f, 0, 0, this.itemArea.m_110091_() + 10, this.itemArea.m_110090_() / 2 + 75);
        ms.m_85849_();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.f_96544_ + 85.0);
    }

    protected void renderChapters(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.chapters.isEmpty()) {
            return;
        }
        int chapterX = (int)((double)this.f_96543_ * 0.5);
        int chapterY = (int)((double)this.f_96544_ * 0.75);
        ms.m_85836_();
        ms.m_85837_((double)chapterX, (double)chapterY, 0.0);
        UIRenderHelper.streak(ms, 0.0f, this.chapterArea.m_110085_() - 10, this.chapterArea.m_110086_() - 20, 20, 220);
        this.f_96547_.m_92883_(ms, "More Topics to Ponder about", (float)(this.chapterArea.m_110085_() - 5), (float)(this.chapterArea.m_110086_() - 25), Theme.i(Theme.Key.TEXT_ACCENT_SLIGHT));
        ms.m_85849_();
    }

    @Override
    protected void renderWindowForeground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69465_();
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 200.0);
        if (!this.hoveredItem.m_41619_()) {
            this.m_6057_(ms, this.hoveredItem, mouseX, mouseY);
        }
        ms.m_85849_();
        RenderSystem.m_69482_();
    }

    @Override
    protected String getBreadcrumbTitle() {
        return this.tag.getTitle();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen) {
            return this.tag == ((PonderTagScreen)other).tag;
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    public void m_7861_() {
        super.m_7861_();
        this.hoveredItem = ItemStack.f_41583_;
    }
}

