/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.api.AdvancementMovedEvent;
import betteradvancements.gui.BetterAdvancementTab;
import betteradvancements.gui.BetterAdvancementWidget;
import betteradvancements.reference.Resources;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class BetterAdvancementsScreen
extends Screen
implements ClientAdvancements.Listener {
    private static final Component VERY_SAD_LABEL = new TranslatableComponent("advancements.sad_label");
    private static final Component NO_ADVANCEMENTS_LABEL = new TranslatableComponent("advancements.empty");
    private static final Component TITLE = new TranslatableComponent("gui.advancements");
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    private static final float MIN_ZOOM = 1.0f;
    private static final float MAX_ZOOM = 2.0f;
    private static final float ZOOM_STEP = 0.2f;
    private final ClientAdvancements clientAdvancements;
    private final Map<Advancement, BetterAdvancementTab> tabs = Maps.newLinkedHashMap();
    private BetterAdvancementTab selectedTab;
    private float zoom = 1.0f;
    private boolean isScrolling;
    protected int internalWidth;
    protected int internalHeight;
    public static int uiScaling;
    public static boolean showDebugCoordinates;
    public static boolean orderTabsAlphabetically;
    private BetterAdvancementWidget advConnectedToMouse = null;

    public BetterAdvancementsScreen(ClientAdvancements clientAdvancements) {
        super(NarratorChatListener.f_93310_);
        this.clientAdvancements = clientAdvancements;
    }

    protected void m_7856_() {
        this.internalHeight = this.f_96544_ * uiScaling / 100;
        this.internalWidth = this.f_96543_ * uiScaling / 100;
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancements.m_104397_((ClientAdvancements.Listener)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.clientAdvancements.m_104401_(this.tabs.values().iterator().next().getAdvancement(), true);
        } else {
            this.clientAdvancements.m_104401_(this.selectedTab == null ? null : this.selectedTab.getAdvancement(), true);
        }
    }

    public void m_7379_() {
        this.clientAdvancements.m_104397_(null);
        ClientPacketListener clientpacketlistener = this.f_96541_.m_91403_();
        if (clientpacketlistener != null) {
            clientpacketlistener.m_104955_((Packet)ServerboundSeenAdvancementsPacket.m_134444_());
        }
        super.m_7379_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int modifiers) {
        if (modifiers == 0) {
            int left = 30 + (this.f_96543_ - this.internalWidth) / 2;
            int top = 40 + (this.f_96544_ - this.internalHeight) / 2;
            for (BetterAdvancementTab betterAdvancementTabGui : this.tabs.values()) {
                if (!betterAdvancementTabGui.isMouseOver(left, top, this.internalWidth - 60, this.internalHeight - top - 30, mouseX, mouseY)) continue;
                this.clientAdvancements.m_104401_(betterAdvancementTabGui.getAdvancement(), true);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        int wheel = (int)scroll;
        if (wheel < 0 && this.zoom > 1.0f) {
            this.zoom -= 0.2f;
        } else if (wheel > 0 && this.zoom < 2.0f) {
            this.zoom += 0.2f;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92055_.m_90832_(keyCode, scanCode)) {
            this.f_96541_.m_91152_(null);
            this.f_96541_.f_91067_.m_91601_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDeltaX, double mouseDeltaY) {
        int left = 30 + (this.f_96543_ - this.internalWidth) / 2;
        int top = 40 + (this.f_96544_ - this.internalHeight) / 2;
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            if (this.advConnectedToMouse == null) {
                boolean inGui;
                boolean bl = inGui = mouseX < (double)(left + this.internalWidth - 60 - 9) && mouseX > (double)(left + 9) && mouseY < (double)(top + this.internalHeight - 40 + 1) && mouseY > (double)(top + 18);
                if (this.selectedTab != null && inGui) {
                    for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.guis.values()) {
                        if (!betterAdvancementEntryScreen.isMouseOver(this.selectedTab.scrollX, this.selectedTab.scrollY, mouseX - (double)left - 9.0, mouseY - (double)top - 18.0) || !betterAdvancementEntryScreen.betterDisplayInfo.allowDragging()) continue;
                        this.advConnectedToMouse = betterAdvancementEntryScreen;
                        break;
                    }
                }
            } else {
                this.advConnectedToMouse.x = (int)Math.round((double)this.advConnectedToMouse.x + mouseDeltaX);
                this.advConnectedToMouse.y = (int)Math.round((double)this.advConnectedToMouse.y + mouseDeltaY);
            }
        } else {
            if (this.advConnectedToMouse != null) {
                AdvancementMovedEvent event = new AdvancementMovedEvent(this.advConnectedToMouse);
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            this.advConnectedToMouse = null;
        }
        if (this.advConnectedToMouse == null) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseDeltaX, mouseDeltaY, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
            }
        }
        return true;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int left = 30 + (this.f_96543_ - this.internalWidth) / 2;
        int top = 40 + (this.f_96544_ - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.f_96543_ - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.f_96544_ - this.internalHeight) / 2;
        this.m_7333_(poseStack);
        this.renderInside(poseStack, mouseX, mouseY, left, top, right, bottom);
        this.renderWindow(poseStack, left, top, right, bottom);
        if (this.advConnectedToMouse == null) {
            this.renderToolTips(poseStack, mouseX, mouseY, left, top, right, bottom);
        }
        if (this.advConnectedToMouse != null) {
            for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.guis.values()) {
                if (betterAdvancementEntryScreen == this.advConnectedToMouse) continue;
                int x1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3;
                int x2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3;
                int y1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY;
                int y2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                int centerX1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerX2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerY1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY + 13;
                int centerY2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY + 13;
                double degrees = Math.toDegrees(Math.atan2(centerX1 - centerX2, centerY1 - centerY2));
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                if (betterAdvancementEntryScreen.x == this.advConnectedToMouse.x) {
                    if (y1 > y2) {
                        RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x1, y2 + 26 - 1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2 + 26 - 1, y1, 1.0, 65280);
                    }
                }
                if (betterAdvancementEntryScreen.y == this.advConnectedToMouse.y) {
                    if (x1 > x2) {
                        RenderUtil.drawRect(x2, y1, x1 + 26 - 1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1 + 26 - 1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1 + 26 - 1, x1, y2 + 26 - 1, 1.0, 65280);
                    }
                }
                if (degrees != 45.0 && degrees != 135.0 && degrees != 225.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x1 + 26 - 1, y1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1 + 26 - 1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1, x1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2 + 26 - 1, y2, 1.0, 65280);
                RenderUtil.drawRect(x2, y2 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2 + 26 - 1, y2, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                if (degrees == 45.0 || degrees == 225.0) {
                    RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                    RenderUtil.drawRect(x1 + 26 - 1, y1, x2 + 26 - 1, y2, 1.0, 65280);
                    continue;
                }
                if (degrees != 135.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x2, y2, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
            }
        }
        if (showDebugCoordinates && this.selectedTab != null && mouseX < this.internalWidth - 30 - 9 && mouseX > 39 && mouseY < this.internalHeight - top + 1 && mouseY > top + 18) {
            if (this.advConnectedToMouse != null) {
                int currentX = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 1;
                int n = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                Objects.requireNonNull(this.f_96547_);
                int currentY = n - 9 + 1;
                this.f_96547_.m_92883_(poseStack, this.advConnectedToMouse.x + "," + this.advConnectedToMouse.y, (float)currentX, (float)currentY, 0);
            } else {
                int xMouse = mouseX - left - 9;
                int yMouse = mouseY - top - 18;
                int currentX = xMouse - this.selectedTab.scrollX - 3 - 1;
                int currentY = yMouse - this.selectedTab.scrollY - 1;
                String string = currentX + "," + currentY;
                float f = mouseX;
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92883_(poseStack, string, f, (float)(mouseY - 9), 0);
            }
        }
    }

    private void renderInside(PoseStack poseStack, int mouseX, int mouseY, int left, int top, int right, int bottom) {
        BetterAdvancementTab betterAdvancementTab = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (betterAdvancementTab == null) {
            BetterAdvancementsScreen.m_93172_((PoseStack)poseStack, (int)boxLeft, (int)boxTop, (int)boxRight, (int)boxBottom, (int)-16777216);
            float f = boxLeft + (width - this.f_96547_.m_92852_((FormattedText)NO_ADVANCEMENTS_LABEL)) / 2;
            int n = boxTop + height / 2;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92889_(poseStack, NO_ADVANCEMENTS_LABEL, f, (float)(n - 9), -1);
            float f2 = boxLeft + (width - this.f_96547_.m_92852_((FormattedText)VERY_SAD_LABEL)) / 2;
            int n2 = boxTop + height / 2;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92889_(poseStack, VERY_SAD_LABEL, f2, (float)(n2 + 9), -1);
        } else {
            PoseStack viewMatrixPoseStack = RenderSystem.m_157191_();
            viewMatrixPoseStack.m_85836_();
            viewMatrixPoseStack.m_85837_((double)boxLeft, (double)boxTop, 0.0);
            RenderSystem.m_157182_();
            betterAdvancementTab.drawContents(poseStack, width, height);
            viewMatrixPoseStack.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
        }
    }

    public void renderWindow(PoseStack poseStack, int left, int top, int right, int bottom) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Resources.Gui.WINDOW);
        this.m_93228_(poseStack, left, top, 0, 0, 30, 30);
        RenderUtil.renderRepeating((GuiComponent)this, poseStack, left + 30, top, this.internalWidth - 30 - 60 - 30, 30, 30, 0, 192, 30);
        this.m_93228_(poseStack, right - 30, top, 222, 0, 30, 30);
        RenderUtil.renderRepeating((GuiComponent)this, poseStack, left, top + 30, 30, bottom - top - 60, 0, 30, 30, 80);
        RenderUtil.renderRepeating((GuiComponent)this, poseStack, right - 30, top + 30, 30, bottom - top - 60, 222, 30, 30, 80);
        this.m_93228_(poseStack, left, bottom - 30, 0, 110, 30, 30);
        RenderUtil.renderRepeating((GuiComponent)this, poseStack, left + 30, bottom - 30, this.internalWidth - 30 - 60 - 30, 30, 30, 110, 192, 30);
        this.m_93228_(poseStack, right - 30, bottom - 30, 222, 110, 30, 30);
        if (this.tabs.size() > 1) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Resources.Gui.TABS);
            int width = right - left;
            int height = bottom - top;
            for (BetterAdvancementTab tab : this.tabs.values()) {
                tab.drawTab(poseStack, left, top, width, height, tab == this.selectedTab);
            }
            RenderSystem.m_69453_();
            for (BetterAdvancementTab tab : this.tabs.values()) {
                tab.drawIcon(poseStack, left, top, width, height, this.f_96542_);
            }
            RenderSystem.m_69461_();
        }
        FormattedCharSequence windowTitle = TITLE.m_7532_();
        if (this.selectedTab != null) {
            windowTitle = FormattedCharSequence.m_144721_((FormattedCharSequence[])new FormattedCharSequence[]{windowTitle, new TextComponent(" - ").m_7532_(), this.selectedTab.getTitle().m_7532_()});
        }
        this.f_96547_.m_92877_(poseStack, windowTitle, (float)(left + 8), (float)(top + 6), 0x404040);
    }

    private void renderToolTips(PoseStack poseStack, int mouseX, int mouseY, int left, int top, int right, int bottom) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            PoseStack viewMatrixPoseStack = RenderSystem.m_157191_();
            viewMatrixPoseStack.m_85836_();
            viewMatrixPoseStack.m_85837_((double)(left + 9), (double)(top + 18), 400.0);
            RenderSystem.m_157182_();
            RenderSystem.m_69482_();
            this.selectedTab.drawToolTips(poseStack, mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27);
            RenderSystem.m_69465_();
            viewMatrixPoseStack.m_85849_();
            RenderSystem.m_157182_();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                this.m_96602_(poseStack, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void m_5513_(@Nonnull Advancement advancement) {
        BetterAdvancementTab betterAdvancementTabGui = BetterAdvancementTab.create(this.f_96541_, this, this.tabs.size(), advancement, this.internalWidth - 60, this.internalHeight - 40 - 30);
        if (betterAdvancementTabGui != null) {
            this.tabs.put(advancement, betterAdvancementTabGui);
        }
    }

    public void m_5504_(@Nonnull Advancement advancement) {
    }

    public void m_5505_(@Nonnull Advancement advancement) {
        BetterAdvancementTab betterAdvancementTabGui = this.getTab(advancement);
        if (betterAdvancementTabGui != null) {
            betterAdvancementTabGui.addAdvancement(advancement);
        }
    }

    public void m_5516_(@Nonnull Advancement advancement) {
    }

    public void m_7922_(@Nonnull Advancement advancement, @Nonnull AdvancementProgress advancementProgress) {
        BetterAdvancementWidget betterAdvancementEntryScreen = this.getAdvancementGui(advancement);
        if (betterAdvancementEntryScreen != null) {
            betterAdvancementEntryScreen.getAdvancementProgress(advancementProgress);
        }
    }

    public void m_6896_(@Nullable Advancement advancement) {
        if (this.selectedTab != null) {
            this.selectedTab.storeScroll();
        }
        this.selectedTab = this.tabs.get(advancement);
        if (this.selectedTab != null) {
            this.selectedTab.loadScroll();
        }
    }

    public void m_7204_() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public BetterAdvancementWidget getAdvancementGui(Advancement advancement) {
        BetterAdvancementTab betterAdvancementTab = this.getTab(advancement);
        return betterAdvancementTab == null ? null : betterAdvancementTab.getWidget(advancement);
    }

    @Nullable
    private BetterAdvancementTab getTab(@Nonnull Advancement advancement) {
        while (advancement.m_138319_() != null) {
            advancement = advancement.m_138319_();
        }
        return this.tabs.get(advancement);
    }

    static {
        showDebugCoordinates = false;
        orderTabsAlphabetically = false;
    }
}

