/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.terraforged.engine.util.pos.PosUtil;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.engine.world.terrain.TerrainType;
import com.terraforged.mod.command.Arg;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.GeneratorPreset;
import com.terraforged.mod.worldgen.Regenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class TFCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(TFCommands.getLocateTerrainCommand());
        dispatcher.register(TFCommands.getTFCommand());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> root(String name) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)name).requires(s -> s.m_6761_(2));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> getLocateTerrainCommand() {
        return (LiteralArgumentBuilder)TFCommands.root("locateterrain").then(((RequiredArgumentBuilder)Arg.terrainType().then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> TFCommands.locate((CommandContext<CommandSourceStack>)c, true)))).executes(c -> TFCommands.locate((CommandContext<CommandSourceStack>)c, false)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> getTFCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)TFCommands.root("tf").then(Commands.m_82127_((String)"export").then(Commands.m_82127_((String)"structures").executes(TFCommands::export)))).then(Commands.m_82127_((String)"regen").then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TFCommands::regen)));
    }

    private static int regen(CommandContext<CommandSourceStack> context) {
        try {
            int radius = IntegerArgumentType.getInteger(context, (String)"radius");
            Vec3 pos = ((CommandSourceStack)context.getSource()).m_81371_();
            ChunkPos chunk = new ChunkPos((int)pos.f_82479_ >> 4, (int)pos.f_82481_ >> 4);
            Regenerator.regenerateChunks(chunk, radius, ((CommandSourceStack)context.getSource()).m_81372_(), (CommandSourceStack)context.getSource());
            return 1;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
    }

    private static int export(CommandContext<CommandSourceStack> context) {
        RegistryAccess access = ((CommandSourceStack)context.getSource()).m_5894_();
        MutableComponent result = new TextComponent("Exported structure settings").m_130938_(s -> s.m_131140_(ChatFormatting.GREEN));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)result, false);
        return 1;
    }

    private static int locate(CommandContext<CommandSourceStack> context, boolean withRadius) throws CommandSyntaxException {
        MutableComponent result;
        Generator generator = GeneratorPreset.getGenerator(((CommandSourceStack)context.getSource()).m_81372_());
        if (generator == null) {
            return 1;
        }
        String name = StringArgumentType.getString(context, (String)"terrain");
        Terrain terrain = TerrainType.get(name);
        int radius = withRadius ? IntegerArgumentType.getInteger(context, (String)"radius") : 1;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        BlockPos at = player.m_142538_();
        if (terrain == null) {
            result = new TextComponent("Invalid terrain: " + name).m_130940_(ChatFormatting.RED);
        } else {
            int maxRadius = Math.min(100, radius + 50);
            long pos = generator.getNoiseGenerator().find(at.m_123341_(), at.m_123343_(), radius, maxRadius, terrain);
            if (pos == 0L) {
                result = new TextComponent("Unable to locate terrain: " + name).m_130940_(ChatFormatting.RED);
            } else {
                int x = PosUtil.unpackLeft(pos);
                int z = PosUtil.unpackRight(pos);
                int y = generator.m_156174_(x, z, Heightmap.Types.MOTION_BLOCKING, (LevelHeightAccessor)player.f_19853_);
                result = TFCommands.createTerrainTeleportMessage(at, x, y, z, terrain);
            }
        }
        player.m_9146_((Component)result, ChatType.SYSTEM, Util.f_137441_);
        return 1;
    }

    private static Component createTerrainTeleportMessage(BlockPos pos, int x, int y, int z, Terrain terrain) {
        double distance = Math.sqrt(pos.m_203198_((double)x, (double)y, (double)z));
        String commandText = String.format("/tp %s %s %s", x, y, z);
        String distanceText = String.format("%.1f", distance);
        String positionText = String.format("%s;%s;%s", x, y, z);
        return new TextComponent("Found terrain: ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(terrain.getName()).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)new TextComponent(" Distance: ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent(distanceText).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)new TextComponent(". ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent("Teleport").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, commandText)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("Location: ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(positionText).m_130940_(ChatFormatting.YELLOW))))));
    }
}

