/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.terraforged.mod.Environment;
import com.terraforged.mod.registry.ModRegistries;
import com.terraforged.mod.registry.ModRegistry;
import com.terraforged.mod.util.seed.RandSeed;
import com.terraforged.mod.worldgen.asset.NoiseCave;
import com.terraforged.mod.worldgen.cave.CaveType;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;

interface ModCaves
extends ModRegistry {
    public static void register() {
        RandSeed seed = new RandSeed(901246L, 500000);
        ModRegistries.register(CAVE, "synapse_high", Factory.synapse(seed.next(), 0.75f, 96, 384));
        ModRegistries.register(CAVE, "synapse_mid", Factory.synapse(seed.next(), 1.0f, 0, 256));
        ModRegistries.register(CAVE, "synapse_low", Factory.synapse(seed.next(), 1.2f, -32, 128));
        ModRegistries.register(CAVE, "mega", Factory.mega(seed.next(), 1.0f, -16, 64));
        ModRegistries.register(CAVE, "mega_deep", Factory.mega(seed.next(), 1.2f, -32, 48));
    }

    public static NoiseCave[] getCaves(RegistryAccess access) {
        if (access == null || Environment.DEV_ENV) {
            return Factory.getDefaults();
        }
        return (NoiseCave[])ModRegistry.entries(access, (ResourceKey)CAVE.get(), NoiseCave[]::new);
    }

    public static class Factory {
        static NoiseCave mega(int seed, float scale, int minY, int maxY) {
            int elevationScale = NoiseUtil.floor(200.0f * scale);
            int networkScale = NoiseUtil.floor(250.0f * scale);
            int floorScale = NoiseUtil.floor(50.0f * scale);
            int size = NoiseUtil.floor(30.0f * scale);
            Module elevation = Source.simplex(++seed, elevationScale, 2).map(0.3, 0.7);
            Module shape = Source.simplex(++seed, networkScale, 3).bias(-0.5).abs().scale(2.0).invert().clamp(0.75, 1.0).map(0.0, 1.0);
            Module floor = Source.simplex(++seed, floorScale, 2).clamp(0.0, 0.3).map(0.0, 1.0);
            return new NoiseCave(seed, CaveType.UNIQUE, elevation, shape, floor, size, minY, maxY);
        }

        static NoiseCave synapse(int seed, float scale, int minY, int maxY) {
            int elevationScale = NoiseUtil.floor(350.0f * scale);
            int networkScale = NoiseUtil.floor(180.0f * scale);
            int networkWarpScale = NoiseUtil.floor(20.0f * scale);
            int networkWarpStrength = networkWarpScale / 2;
            int floorScale = NoiseUtil.floor(30.0f * scale);
            int size = NoiseUtil.floor(15.0f * scale);
            Module elevation = Source.simplex(++seed, elevationScale, 3).map(0.1, 0.9);
            Module shape = Source.simplexRidge(++seed, networkScale, 3).warp(++seed, networkWarpScale, 1, networkWarpStrength).clamp(0.35, 0.75).map(0.0, 1.0);
            Module floor = Source.simplex(++seed, floorScale, 2).clamp(0.0, 0.15).map(0.0, 1.0);
            return new NoiseCave(seed, CaveType.GLOBAL, elevation, shape, floor, size, minY, maxY);
        }

        static NoiseCave[] getDefaults() {
            RandSeed seed = new RandSeed(901246L, 500000);
            return new NoiseCave[]{Factory.synapse(seed.next(), 0.75f, 96, 384), Factory.synapse(seed.next(), 1.0f, 0, 256), Factory.synapse(seed.next(), 1.2f, -32, 128), Factory.mega(seed.next(), 1.0f, -16, 64), Factory.mega(seed.next(), 1.2f, -32, 48)};
        }
    }
}

