/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.registry.lazy.LazyRegistry;
import com.terraforged.mod.util.Init;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ModRegistries
extends Init {
    public static final ModRegistries INSTANCE = new ModRegistries();
    private final List<HolderEntry<?>> holders = new ArrayList();
    private final Map<ResourceKey<? extends Registry<?>>, MappedRegistry<?>> registries = new IdentityHashMap();

    @Override
    protected void doInit() {
    }

    public static void commit() {
        INSTANCE.init();
    }

    public static List<HolderEntry<?>> getHolders() {
        return ModRegistries.INSTANCE.holders;
    }

    public static <T> void createRegistry(LazyRegistry<T> key, Codec<T> codec) {
        ModRegistries.createRegistry((ResourceKey)key.get(), codec);
    }

    public static <T> void createRegistry(ResourceKey<Registry<T>> key, Codec<T> codec) {
        if (INSTANCE.isDone()) {
            TerraForged.LOG.warn("Attempted to register extension after init: {}", key);
            return;
        }
        MappedRegistry registry = new MappedRegistry(key, Lifecycle.stable(), null);
        HolderEntry<T> holder = new HolderEntry<T>(registry, codec);
        ModRegistries.INSTANCE.holders.add(holder);
        ModRegistries.INSTANCE.registries.put(key, registry);
    }

    public static <T> ResourceKey<T> register(LazyRegistry<T> registryKey, String name, T value) {
        return ModRegistries.register((ResourceKey)registryKey.get(), name, value);
    }

    public static <T> ResourceKey<T> register(ResourceKey<Registry<T>> registryKey, String name, T value) {
        MappedRegistry<T> registry = ModRegistries.getRegistry(registryKey);
        ResourceKey entryKey = ResourceKey.m_135785_(registryKey, (ResourceLocation)TerraForged.location(name));
        registry.m_203505_(entryKey, value, Lifecycle.stable());
        return entryKey;
    }

    public static <T> Holder<T> holder(ResourceKey<Registry<T>> registry, String name) {
        ResourceLocation location = TerraForged.location(name);
        ResourceKey key = ResourceKey.m_135785_(registry, (ResourceLocation)location);
        return Holder.Reference.m_205766_(ModRegistries.getRegistry(registry), (ResourceKey)key);
    }

    private static <T> T getEntry(ResourceKey<Registry<T>> registry, ResourceLocation name) {
        Object t = ModRegistries.getRegistry(registry).m_7745_(name);
        if (t == null) {
            throw new Error("Missing entry: " + name + ", Registry: " + registry.m_135782_());
        }
        return (T)t;
    }

    public static <T> MappedRegistry<T> getRegistry(ResourceKey<Registry<T>> key) {
        MappedRegistry<?> registry = ModRegistries.INSTANCE.registries.get(key);
        if (registry == null) {
            throw new Error("Missing registry: " + key);
        }
        return registry;
    }

    public record HolderEntry<T>(Registry<T> registry, Codec<T> direct) {
        public ResourceKey<? extends Registry<T>> key() {
            return this.registry.m_123023_();
        }
    }
}

