/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.decorator;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.biome.surface.Surface;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.mod.worldgen.util.NoiseChunkUtil;
import net.minecraft.core.Registry;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;

public class SurfaceDecorator {
    public void decorate(ChunkAccess chunk, WorldGenRegion region, Generator generator) {
        WorldGenerationContext context = new WorldGenerationContext((ChunkGenerator)generator, (LevelHeightAccessor)region);
        NoiseChunk noiseChunk = NoiseChunkUtil.getNoiseChunk(chunk, generator);
        Registry<Biome> biomes = generator.getBiomeSource().getRegistry();
        BiomeManager biomeManager = region.m_7062_();
        SurfaceSystem surface = generator.getVanillaGen().getSurfaceSystem();
        SurfaceRules.RuleSource surfaceRules = ((NoiseGeneratorSettings)generator.getVanillaGen().getSettings().m_203334_()).f_188871_();
        surface.m_189944_(biomeManager, biomes, false, context, chunk, noiseChunk, surfaceRules);
    }

    public void decoratePost(ChunkAccess chunk, Generator generator) {
        TerrainData chunkData = generator.getChunkData(chunk.m_7697_());
        Surface.apply(chunkData, chunk, generator);
    }
}

