/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.decorator;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.biome.decorator.FeatureDecorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class VanillaDecorator {
    public static void decorate(long seed, int from, int to, BlockPos origin, Holder<Biome> biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureFeatureManager structureManager, FeatureDecorator decorator) {
        for (int stage = from; stage <= to; ++stage) {
            List<Holder<ConfiguredStructureFeature<?, ?>>> structures = decorator.getStageStructures(stage);
            HolderSet<PlacedFeature> features = decorator.getStageFeatures(stage, (Biome)biome.m_203334_());
            if (features == null) continue;
            VanillaDecorator.placeStructures(seed, stage, chunk, level, generator, random, structureManager, structures);
            VanillaDecorator.placeFeatures(seed, structures.size(), stage, origin, level, generator, random, features);
        }
    }

    private static void placeStructures(long seed, int stage, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureFeatureManager structureManager, List<Holder<ConfiguredStructureFeature<?, ?>>> structures) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_());
        for (int structureIndex = 0; structureIndex < structures.size(); ++structureIndex) {
            random.m_190064_(seed, structureIndex, stage);
            Holder<ConfiguredStructureFeature<?, ?>> structure = structures.get(structureIndex);
            List starts = structureManager.m_207794_(sectionPos, (ConfiguredStructureFeature)structure.m_203334_());
            for (int startIndex = 0; startIndex < starts.size(); ++startIndex) {
                StructureStart start = (StructureStart)starts.get(startIndex);
                start.m_7129_(level, structureManager, (ChunkGenerator)generator, (Random)random, VanillaDecorator.getWritableArea(chunk), chunkPos);
            }
        }
    }

    private static void placeFeatures(long seed, int offset, int stage, BlockPos origin, WorldGenLevel level, Generator generator, WorldgenRandom random, HolderSet<PlacedFeature> features) {
        for (int i = 0; i < features.m_203632_(); ++i) {
            random.m_190064_(seed, offset + i, stage);
            PlacedFeature feature = (PlacedFeature)features.m_203662_(i).m_203334_();
            feature.m_191806_(level, (ChunkGenerator)generator, (Random)random, origin);
        }
    }

    public static Map<GenerationStep.Decoration, List<Holder<ConfiguredStructureFeature<?, ?>>>> buildStructureMap(RegistryAccess access) {
        EnumMap map = new EnumMap(GenerationStep.Decoration.class);
        Registry registry = access.m_175515_(Registry.f_122882_);
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            ConfiguredStructureFeature value = (ConfiguredStructureFeature)entry.getValue();
            map.computeIfAbsent(value.f_65403_.m_67095_(), s -> new ArrayList()).add(registry.m_206081_(key));
        }
        for (GenerationStep.Decoration stage : FeatureDecorator.STAGES) {
            if (map.containsKey(stage)) continue;
            map.put(stage, Collections.emptyList());
        }
        return map;
    }

    private static BoundingBox getWritableArea(ChunkAccess chunkAccess) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        int minX = chunkPos.m_45604_();
        int minZ = chunkPos.m_45605_();
        LevelHeightAccessor levelHeightAccessor = chunkAccess.m_183618_();
        int minY = levelHeightAccessor.m_141937_() + 1;
        int maxY = levelHeightAccessor.m_151558_() - 1;
        return new BoundingBox(minX, minY, minZ, minX + 15, maxY, minZ + 15);
    }
}

