/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.util;

import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.platform.CommonAPI;
import com.terraforged.mod.worldgen.biome.util.matcher.BiomeMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;

public class BiomeUtil {
    private static final Map<BiomeType, ResourceLocation> TYPE_NAMES = new EnumMap<BiomeType, ResourceLocation>(BiomeType.class);
    private static final Comparator<ResourceKey<?>> KEY_COMPARATOR = Comparator.comparing(ResourceKey::m_135782_);
    public static Comparator<Holder<Biome>> BIOME_SORTER = (o1, o2) -> {
        ResourceKey k1 = (ResourceKey)o1.m_203543_().orElseThrow();
        ResourceKey k2 = (ResourceKey)o2.m_203543_().orElseThrow();
        Objects.requireNonNull(k1);
        Objects.requireNonNull(k2);
        return KEY_COMPARATOR.compare(k1, k2);
    };

    public static ResourceLocation getRegistryName(BiomeType type) {
        return TYPE_NAMES.get((Object)type);
    }

    public static List<Holder<Biome>> getOverworldBiomes(RegistryAccess access) {
        return BiomeUtil.getOverworldBiomes((Registry<Biome>)access.m_175515_(Registry.f_122885_));
    }

    public static List<Holder<Biome>> getOverworldBiomes(Registry<Biome> biomes) {
        Set<Holder<Biome>> overworld = BiomeUtil.getVanillaOverworldBiomes(biomes);
        BiomeMatcher matcher = CommonAPI.get().getOverworldMatcher();
        for (Holder holder : biomes.m_206115_()) {
            if (overworld.contains(holder) || !matcher.test((Holder<Biome>)holder)) continue;
            overworld.add((Holder<Biome>)holder);
        }
        ArrayList<Holder<Biome>> result = new ArrayList<Holder<Biome>>(overworld);
        result.sort(BIOME_SORTER);
        return result;
    }

    public static BiomeType getType(Holder<Biome> biome) {
        return switch (Biome.m_204183_(biome)) {
            case Biome.BiomeCategory.MESA, Biome.BiomeCategory.DESERT -> BiomeType.DESERT;
            case Biome.BiomeCategory.PLAINS -> BiomeUtil.getByTemp((Biome)biome.m_203334_(), BiomeType.COLD_STEPPE, BiomeType.GRASSLAND, BiomeType.STEPPE);
            case Biome.BiomeCategory.TAIGA -> BiomeUtil.getByTemp((Biome)biome.m_203334_(), BiomeType.TUNDRA, BiomeType.TAIGA);
            case Biome.BiomeCategory.ICY -> BiomeType.TUNDRA;
            case Biome.BiomeCategory.SAVANNA -> BiomeType.SAVANNA;
            case Biome.BiomeCategory.JUNGLE -> BiomeType.TROPICAL_RAINFOREST;
            case Biome.BiomeCategory.FOREST -> BiomeUtil.getByRain((Biome)biome.m_203334_(), BiomeType.TUNDRA, BiomeType.TEMPERATE_RAINFOREST, BiomeType.TEMPERATE_FOREST);
            case Biome.BiomeCategory.MOUNTAIN -> BiomeType.ALPINE;
            default -> null;
        };
    }

    public static BiomeType getByRain(Biome biome, BiomeType frozen, BiomeType wetter, BiomeType dryer) {
        if (biome.m_47530_() == Biome.Precipitation.SNOW) {
            return frozen;
        }
        return (double)biome.m_47548_() >= 0.8 ? wetter : dryer;
    }

    public static BiomeType getByTemp(Biome biome, BiomeType colder, BiomeType warmer) {
        return biome.m_47530_() == Biome.Precipitation.SNOW ? colder : warmer;
    }

    public static BiomeType getByTemp(Biome biome, BiomeType cold, BiomeType temperate, BiomeType hot) {
        if (biome.m_47530_() == Biome.Precipitation.SNOW) {
            return cold;
        }
        if (biome.m_47530_() == Biome.Precipitation.NONE || (double)biome.m_47554_() > 1.0) {
            return hot;
        }
        return temperate;
    }

    private static Set<Holder<Biome>> getVanillaOverworldBiomes(Registry<Biome> biomes) {
        return new HashSet<Holder<Biome>>(MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(biomes).m_207840_());
    }

    static {
        for (BiomeType type : BiomeType.values()) {
            TYPE_NAMES.put(type, TerraForged.location(type.name().toLowerCase(Locale.ROOT)));
        }
    }
}

