/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.cave;

import com.terraforged.mod.util.MathUtil;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.asset.NoiseCave;
import com.terraforged.mod.worldgen.cave.CarverChunk;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;

public class NoiseCaveCarver {
    private static final int CHUNK_AREA = 256;

    public static void carve(ChunkAccess chunk, CarverChunk carver, Generator generator, NoiseCave config, boolean carve) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minY = generator.m_142062_();
        int startX = chunk.m_7697_().m_45604_();
        int startZ = chunk.m_7697_().m_45605_();
        for (int i = 0; i < 256; ++i) {
            int bottom;
            int dx = i & 0xF;
            int dz = i >> 4;
            int x = startX + dx;
            int z = startZ + dz;
            int surface = NoiseCaveCarver.getSurface(x, z, chunk, generator, carver);
            int y = config.getHeight(x, z);
            float value = carver.modifier.getValue(x, z);
            int cavern = config.getCavernSize(x, z, value);
            if (cavern == 0) continue;
            int floor = config.getFloorDepth(x, z, cavern);
            int top = MathUtil.clamp(y + cavern, minY, surface);
            if (top - (bottom = MathUtil.clamp(y - floor, minY, surface)) < 2) continue;
            Holder<Biome> biome = carver.getBiome(x, z, config, generator);
            if (!carve) continue;
            NoiseCaveCarver.carve(chunk, biome, dx, dz, bottom, top, surface, pos);
        }
    }

    private static void carve(ChunkAccess chunk, Holder<Biome> biome, int dx, int dz, int bottom, int top, int surface, BlockPos.MutableBlockPos pos) {
        BlockState air = Blocks.f_50016_.m_49966_();
        int biomeX = dx >> 2;
        int biomeZ = dz >> 2;
        int maxBiomeY = surface - 16 >> 2;
        for (int cy = bottom; cy <= top; ++cy) {
            pos.m_122178_(dx, cy, dz);
            if (!chunk.m_8055_((BlockPos)pos).m_60819_().m_76178_()) continue;
            chunk.m_6978_((BlockPos)pos, air, false);
            if (cy >> 2 >= maxBiomeY) continue;
            int biomeY = (cy & 0xF) >> 2;
            int sectionIndex = chunk.m_151564_(cy);
            LevelChunkSection section = chunk.m_183278_(sectionIndex);
            section.m_188013_().m_63127_(biomeX, biomeY, biomeZ, biome);
        }
    }

    private static int getSurface(int x, int z, ChunkAccess chunk, Generator generator, CarverChunk carverChunk) {
        float mask = carverChunk.getCarvingMask(x, z);
        int surface = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z) - 1;
        if (surface > generator.m_6337_() || surface < generator.m_6337_() - 16) {
            surface += 9;
        }
        return surface - NoiseUtil.floor(16.0f * mask);
    }
}

