/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.cave;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.asset.NoiseCave;
import com.terraforged.mod.worldgen.biome.util.BiomeList;
import com.terraforged.mod.worldgen.cave.CarverChunk;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class NoiseCaveDecorator {
    public static void decorate(ChunkAccess chunk, CarverChunk carver, WorldGenLevel region, Generator generator, NoiseCave config) {
        BiomeList biomes = carver.getBiomes(config);
        if (biomes == null) {
            return;
        }
        int startX = chunk.m_7697_().m_45604_();
        int startZ = chunk.m_7697_().m_45605_();
        int startY = config.getHeight(startX, startZ);
        BlockPos pos = new BlockPos(startX, startY, startZ);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(region.m_7328_()));
        for (int i = 0; i < biomes.size(); ++i) {
            Holder<Biome> biome = biomes.get(i);
            NoiseCaveDecorator.decorate(pos, region, generator, ((Biome)biome.m_203334_()).m_47536_(), random);
        }
    }

    public static void decorate(BlockPos pos, WorldGenLevel region, Generator generator, BiomeGenerationSettings settings, WorldgenRandom random) {
        List features = settings.m_47818_();
        long baseSeed = random.m_64690_(region.m_7328_(), pos.m_123341_(), pos.m_123343_());
        for (int stageIndex = 0; stageIndex < features.size(); ++stageIndex) {
            if (stageIndex < GenerationStep.Decoration.LOCAL_MODIFICATIONS.ordinal()) continue;
            HolderSet stage = (HolderSet)features.get(stageIndex);
            for (int featureIndex = 0; featureIndex < stage.m_203632_(); ++featureIndex) {
                random.m_190064_(baseSeed, featureIndex, stageIndex);
                PlacedFeature feature = (PlacedFeature)stage.m_203662_(featureIndex).m_203334_();
                feature.m_191806_(region, (ChunkGenerator)generator, (Random)random, pos);
            }
        }
    }
}

