/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.util;

import com.terraforged.mod.util.ReflectionUtil;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.VanillaGen;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.mod.worldgen.util.NoopNoise;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.blending.Blender;

public class NoiseChunkUtil {
    private static final MethodHandle SURFACE_CACHE = ReflectionUtil.field(NoiseChunk.class, Long2IntMap.class, new String[0]);

    public static void initChunk(ChunkAccess chunk, Generator generator) {
        NoiseChunkUtil.getNoiseChunk(chunk, generator);
    }

    public static NoiseChunk getNoiseChunk(ChunkAccess chunk, Generator generator) {
        VanillaGen vanilla = generator.getVanillaGen();
        Aquifer.FluidPicker fluidPicker = vanilla.getGlobalFluidPicker();
        NoiseGeneratorSettings settings = (NoiseGeneratorSettings)vanilla.getSettings().m_203334_();
        CompletableFuture<TerrainData> terrainData = generator.getChunkDataAsync(chunk.m_7697_());
        NoiseChunk noiseChunk = chunk.m_207937_(NoopNoise.ROUTER, NoopNoise.BEARDIFIER, settings, fluidPicker, Blender.m_190153_());
        NoiseChunkUtil.initChunk(chunk, noiseChunk, terrainData);
        return noiseChunk;
    }

    private static void initChunk(ChunkAccess chunk, NoiseChunk noiseChunk, CompletableFuture<TerrainData> terrainData) {
        Long2IntMap cache = NoiseChunkUtil.getCache(noiseChunk);
        if (!cache.isEmpty()) {
            return;
        }
        NoiseChunkUtil.initSurfaceCache(chunk, cache, terrainData);
    }

    private static void initSurfaceCache(ChunkAccess chunk, Long2IntMap cache, CompletableFuture<TerrainData> terrainData) {
        int dx;
        int dz;
        ChunkPos chunkPos = chunk.m_7697_();
        TerrainData data = terrainData.join();
        int startX = chunkPos.m_45604_();
        int startZ = chunkPos.m_45605_();
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        cache.clear();
        for (dz = 0; dz < 16; ++dz) {
            for (dx = 0; dx < 16; ++dx) {
                int height = data.getHeight(dx, dz);
                int qx = QuartPos.m_175400_((int)(startX + dx));
                int qz = QuartPos.m_175400_((int)(startZ + dz));
                long index = ChunkPos.m_45589_((int)qx, (int)qz);
                cache.put(index, height);
                min = Math.min(min, height);
                max = Math.max(max, height);
            }
        }
        for (dz = -16; dz < 32; ++dz) {
            for (dx = -16; dx < 32; ++dx) {
                if ((dx & 0xF) == dx && (dz & 0xF) == dz) continue;
                int qx = QuartPos.m_175400_((int)(startX + dx));
                int qz = QuartPos.m_175400_((int)(startZ + dz));
                long index = ChunkPos.m_45589_((int)qx, (int)qz);
                cache.put(index, min);
            }
        }
    }

    private static Long2IntMap getCache(NoiseChunk noiseChunk) {
        try {
            return SURFACE_CACHE.invokeExact(noiseChunk);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }
}

