/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.config;

import com.google.gson.annotations.Expose;
import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.config.enums.AdjacentStopMode;
import fr.raksrinana.fallingtree.common.config.enums.BreakMode;
import fr.raksrinana.fallingtree.common.config.enums.BreakOrder;
import fr.raksrinana.fallingtree.common.config.enums.DetectionMode;
import fr.raksrinana.fallingtree.common.config.enums.MaxSizeAction;
import fr.raksrinana.fallingtree.common.wrapper.IBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TreeConfiguration {
    @Expose
    @NotNull
    private List<String> allowedLogs = new ArrayList<String>();
    @Expose
    @NotNull
    private List<String> deniedLogs = new ArrayList<String>();
    @Expose
    @NotNull
    private List<String> allowedLeaves = new ArrayList<String>();
    @Expose
    @NotNull
    private List<String> allowedNonDecayLeaves = new ArrayList<String>();
    @Expose
    @NotNull
    private List<String> deniedLeaves = new ArrayList<String>();
    @Expose
    @NotNull
    private BreakMode breakMode = BreakMode.INSTANTANEOUS;
    @Expose
    @NotNull
    private DetectionMode detectionMode = DetectionMode.WHOLE_TREE;
    @Expose
    private int maxScanSize = 500;
    @Expose
    private int maxSize = 100;
    @Expose
    @NotNull
    private MaxSizeAction maxSizeAction = MaxSizeAction.ABORT;
    @Expose
    @NotNull
    private BreakOrder breakOrder = BreakOrder.FURTHEST_FIRST;
    @Expose
    private int minimumLeavesAroundRequired = 1;
    @Expose
    private boolean includePersistentLeavesInRequiredCount = true;
    @Expose
    private boolean treeBreaking = true;
    @Expose
    private boolean leavesBreaking = true;
    @Expose
    private int leavesBreakingForceRadius = 0;
    @Expose
    private boolean allowMixedLogs = false;
    @Expose
    private boolean breakNetherTreeWarts = true;
    @Expose
    private boolean instantlyBreakWarts = false;
    @Expose
    private int searchAreaRadius = -1;
    @Expose
    @NotNull
    private List<String> allowedAdjacentBlocks = new ArrayList<String>();
    @Expose
    @NotNull
    private AdjacentStopMode adjacentStopMode = AdjacentStopMode.STOP_ALL;
    private Set<IBlock> deniedLeavesCache;
    private Set<IBlock> deniedLogsCache;
    private Set<IBlock> allowedLeavesCache;
    private Set<IBlock> allowedNonDecayLeavesCache;
    private Set<IBlock> allowedLogsCache;
    private Set<IBlock> allowedAdjacentBlocksCache;
    private Set<IBlock> adjacentBlocksBaseCache;
    private Set<IBlock> defaultLogsBlocksCache;

    @NotNull
    public Collection<IBlock> getAllowedNonDecayLeaveBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.allowedNonDecayLeavesCache)) {
            this.allowedNonDecayLeavesCache = common.getAsBlocks(this.getAllowedNonDecayLeaves());
        }
        return this.allowedNonDecayLeavesCache;
    }

    @NotNull
    public Collection<IBlock> getDeniedLeaveBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.deniedLeavesCache)) {
            this.deniedLeavesCache = common.getAsBlocks(this.getDeniedLeaves());
        }
        return this.deniedLeavesCache;
    }

    @NotNull
    public Collection<IBlock> getDeniedLogBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.deniedLogsCache)) {
            this.deniedLogsCache = common.getAsBlocks(this.getDeniedLogs());
        }
        return this.deniedLogsCache;
    }

    @NotNull
    public Collection<IBlock> getAllowedLeaveBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.allowedLeavesCache)) {
            this.allowedLeavesCache = common.getAsBlocks(this.getAllowedLeaves());
        }
        return this.allowedLeavesCache;
    }

    @NotNull
    public Collection<IBlock> getAllowedLogBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.allowedLogsCache)) {
            this.allowedLogsCache = common.getAsBlocks(this.getAllowedLogs());
        }
        return this.allowedLogsCache;
    }

    @NotNull
    public Collection<IBlock> getAllowedAdjacentBlockBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.allowedAdjacentBlocksCache)) {
            this.allowedAdjacentBlocksCache = common.getAsBlocks(this.getAllowedAdjacentBlocks());
        }
        return this.allowedAdjacentBlocksCache;
    }

    @NotNull
    public Collection<IBlock> getDefaultLogsBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.defaultLogsBlocksCache)) {
            this.defaultLogsBlocksCache = common.getAllNonStrippedLogsBlocks();
        }
        return this.defaultLogsBlocksCache;
    }

    @NotNull
    public Collection<IBlock> getAllAllowedAdjacentBlockBlocks(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(this.allowedAdjacentBlocksCache)) {
            this.allowedAdjacentBlocksCache = new HashSet<IBlock>();
            common.getBlock("minecraft:air").forEach(this.allowedAdjacentBlocksCache::add);
            common.getBlock("#minecraft:leaves").forEach(this.allowedAdjacentBlocksCache::add);
            this.allowedAdjacentBlocksCache.addAll(this.getDefaultLogsBlocks(common));
            this.allowedAdjacentBlocksCache.addAll(this.getAllowedLogBlocks(common));
            this.allowedAdjacentBlocksCache.addAll(this.getAllowedLeaveBlocks(common));
            this.allowedAdjacentBlocksCache.addAll(this.getAllowedNonDecayLeaveBlocks(common));
            this.allowedAdjacentBlocksCache.removeAll(this.getDeniedLogBlocks(common));
            this.allowedAdjacentBlocksCache.removeAll(this.getDeniedLeaveBlocks(common));
        }
        return this.allowedAdjacentBlocksCache;
    }

    public void invalidate() {
        this.deniedLeavesCache = null;
        this.deniedLogsCache = null;
        this.allowedLeavesCache = null;
        this.allowedNonDecayLeavesCache = null;
        this.allowedLogsCache = null;
        this.allowedAdjacentBlocksCache = null;
        this.adjacentBlocksBaseCache = null;
        this.defaultLogsBlocksCache = null;
    }

    @NotNull
    public List<String> getAllowedLogs() {
        return this.allowedLogs;
    }

    @NotNull
    public List<String> getDeniedLogs() {
        return this.deniedLogs;
    }

    @NotNull
    public List<String> getAllowedLeaves() {
        return this.allowedLeaves;
    }

    @NotNull
    public List<String> getAllowedNonDecayLeaves() {
        return this.allowedNonDecayLeaves;
    }

    @NotNull
    public List<String> getDeniedLeaves() {
        return this.deniedLeaves;
    }

    @NotNull
    public BreakMode getBreakMode() {
        return this.breakMode;
    }

    @NotNull
    public DetectionMode getDetectionMode() {
        return this.detectionMode;
    }

    public int getMaxScanSize() {
        return this.maxScanSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @NotNull
    public MaxSizeAction getMaxSizeAction() {
        return this.maxSizeAction;
    }

    @NotNull
    public BreakOrder getBreakOrder() {
        return this.breakOrder;
    }

    public int getMinimumLeavesAroundRequired() {
        return this.minimumLeavesAroundRequired;
    }

    public boolean isIncludePersistentLeavesInRequiredCount() {
        return this.includePersistentLeavesInRequiredCount;
    }

    public boolean isTreeBreaking() {
        return this.treeBreaking;
    }

    public boolean isLeavesBreaking() {
        return this.leavesBreaking;
    }

    public int getLeavesBreakingForceRadius() {
        return this.leavesBreakingForceRadius;
    }

    public boolean isAllowMixedLogs() {
        return this.allowMixedLogs;
    }

    public boolean isBreakNetherTreeWarts() {
        return this.breakNetherTreeWarts;
    }

    public boolean isInstantlyBreakWarts() {
        return this.instantlyBreakWarts;
    }

    public int getSearchAreaRadius() {
        return this.searchAreaRadius;
    }

    @NotNull
    public List<String> getAllowedAdjacentBlocks() {
        return this.allowedAdjacentBlocks;
    }

    @NotNull
    public AdjacentStopMode getAdjacentStopMode() {
        return this.adjacentStopMode;
    }

    public Set<IBlock> getDeniedLeavesCache() {
        return this.deniedLeavesCache;
    }

    public Set<IBlock> getDeniedLogsCache() {
        return this.deniedLogsCache;
    }

    public Set<IBlock> getAllowedLeavesCache() {
        return this.allowedLeavesCache;
    }

    public Set<IBlock> getAllowedNonDecayLeavesCache() {
        return this.allowedNonDecayLeavesCache;
    }

    public Set<IBlock> getAllowedLogsCache() {
        return this.allowedLogsCache;
    }

    public Set<IBlock> getAllowedAdjacentBlocksCache() {
        return this.allowedAdjacentBlocksCache;
    }

    public Set<IBlock> getAdjacentBlocksBaseCache() {
        return this.adjacentBlocksBaseCache;
    }

    public Set<IBlock> getDefaultLogsBlocksCache() {
        return this.defaultLogsBlocksCache;
    }

    public void setAllowedLogs(@NotNull List<String> allowedLogs) {
        if (allowedLogs == null) {
            throw new NullPointerException("allowedLogs is marked non-null but is null");
        }
        this.allowedLogs = allowedLogs;
    }

    public void setDeniedLogs(@NotNull List<String> deniedLogs) {
        if (deniedLogs == null) {
            throw new NullPointerException("deniedLogs is marked non-null but is null");
        }
        this.deniedLogs = deniedLogs;
    }

    public void setAllowedLeaves(@NotNull List<String> allowedLeaves) {
        if (allowedLeaves == null) {
            throw new NullPointerException("allowedLeaves is marked non-null but is null");
        }
        this.allowedLeaves = allowedLeaves;
    }

    public void setAllowedNonDecayLeaves(@NotNull List<String> allowedNonDecayLeaves) {
        if (allowedNonDecayLeaves == null) {
            throw new NullPointerException("allowedNonDecayLeaves is marked non-null but is null");
        }
        this.allowedNonDecayLeaves = allowedNonDecayLeaves;
    }

    public void setDeniedLeaves(@NotNull List<String> deniedLeaves) {
        if (deniedLeaves == null) {
            throw new NullPointerException("deniedLeaves is marked non-null but is null");
        }
        this.deniedLeaves = deniedLeaves;
    }

    public void setBreakMode(@NotNull BreakMode breakMode) {
        if (breakMode == null) {
            throw new NullPointerException("breakMode is marked non-null but is null");
        }
        this.breakMode = breakMode;
    }

    public void setDetectionMode(@NotNull DetectionMode detectionMode) {
        if (detectionMode == null) {
            throw new NullPointerException("detectionMode is marked non-null but is null");
        }
        this.detectionMode = detectionMode;
    }

    public void setMaxScanSize(int maxScanSize) {
        this.maxScanSize = maxScanSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMaxSizeAction(@NotNull MaxSizeAction maxSizeAction) {
        if (maxSizeAction == null) {
            throw new NullPointerException("maxSizeAction is marked non-null but is null");
        }
        this.maxSizeAction = maxSizeAction;
    }

    public void setBreakOrder(@NotNull BreakOrder breakOrder) {
        if (breakOrder == null) {
            throw new NullPointerException("breakOrder is marked non-null but is null");
        }
        this.breakOrder = breakOrder;
    }

    public void setMinimumLeavesAroundRequired(int minimumLeavesAroundRequired) {
        this.minimumLeavesAroundRequired = minimumLeavesAroundRequired;
    }

    public void setIncludePersistentLeavesInRequiredCount(boolean includePersistentLeavesInRequiredCount) {
        this.includePersistentLeavesInRequiredCount = includePersistentLeavesInRequiredCount;
    }

    public void setTreeBreaking(boolean treeBreaking) {
        this.treeBreaking = treeBreaking;
    }

    public void setLeavesBreaking(boolean leavesBreaking) {
        this.leavesBreaking = leavesBreaking;
    }

    public void setLeavesBreakingForceRadius(int leavesBreakingForceRadius) {
        this.leavesBreakingForceRadius = leavesBreakingForceRadius;
    }

    public void setAllowMixedLogs(boolean allowMixedLogs) {
        this.allowMixedLogs = allowMixedLogs;
    }

    public void setBreakNetherTreeWarts(boolean breakNetherTreeWarts) {
        this.breakNetherTreeWarts = breakNetherTreeWarts;
    }

    public void setInstantlyBreakWarts(boolean instantlyBreakWarts) {
        this.instantlyBreakWarts = instantlyBreakWarts;
    }

    public void setSearchAreaRadius(int searchAreaRadius) {
        this.searchAreaRadius = searchAreaRadius;
    }

    public void setAllowedAdjacentBlocks(@NotNull List<String> allowedAdjacentBlocks) {
        if (allowedAdjacentBlocks == null) {
            throw new NullPointerException("allowedAdjacentBlocks is marked non-null but is null");
        }
        this.allowedAdjacentBlocks = allowedAdjacentBlocks;
    }

    public void setAdjacentStopMode(@NotNull AdjacentStopMode adjacentStopMode) {
        if (adjacentStopMode == null) {
            throw new NullPointerException("adjacentStopMode is marked non-null but is null");
        }
        this.adjacentStopMode = adjacentStopMode;
    }

    public void setDeniedLeavesCache(Set<IBlock> deniedLeavesCache) {
        this.deniedLeavesCache = deniedLeavesCache;
    }

    public void setDeniedLogsCache(Set<IBlock> deniedLogsCache) {
        this.deniedLogsCache = deniedLogsCache;
    }

    public void setAllowedLeavesCache(Set<IBlock> allowedLeavesCache) {
        this.allowedLeavesCache = allowedLeavesCache;
    }

    public void setAllowedNonDecayLeavesCache(Set<IBlock> allowedNonDecayLeavesCache) {
        this.allowedNonDecayLeavesCache = allowedNonDecayLeavesCache;
    }

    public void setAllowedLogsCache(Set<IBlock> allowedLogsCache) {
        this.allowedLogsCache = allowedLogsCache;
    }

    public void setAllowedAdjacentBlocksCache(Set<IBlock> allowedAdjacentBlocksCache) {
        this.allowedAdjacentBlocksCache = allowedAdjacentBlocksCache;
    }

    public void setAdjacentBlocksBaseCache(Set<IBlock> adjacentBlocksBaseCache) {
        this.adjacentBlocksBaseCache = adjacentBlocksBaseCache;
    }

    public void setDefaultLogsBlocksCache(Set<IBlock> defaultLogsBlocksCache) {
        this.defaultLogsBlocksCache = defaultLogsBlocksCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeConfiguration)) {
            return false;
        }
        TreeConfiguration other = (TreeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxScanSize() != other.getMaxScanSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getMinimumLeavesAroundRequired() != other.getMinimumLeavesAroundRequired()) {
            return false;
        }
        if (this.isIncludePersistentLeavesInRequiredCount() != other.isIncludePersistentLeavesInRequiredCount()) {
            return false;
        }
        if (this.isTreeBreaking() != other.isTreeBreaking()) {
            return false;
        }
        if (this.isLeavesBreaking() != other.isLeavesBreaking()) {
            return false;
        }
        if (this.getLeavesBreakingForceRadius() != other.getLeavesBreakingForceRadius()) {
            return false;
        }
        if (this.isAllowMixedLogs() != other.isAllowMixedLogs()) {
            return false;
        }
        if (this.isBreakNetherTreeWarts() != other.isBreakNetherTreeWarts()) {
            return false;
        }
        if (this.isInstantlyBreakWarts() != other.isInstantlyBreakWarts()) {
            return false;
        }
        if (this.getSearchAreaRadius() != other.getSearchAreaRadius()) {
            return false;
        }
        List<String> this$allowedLogs = this.getAllowedLogs();
        List<String> other$allowedLogs = other.getAllowedLogs();
        if (this$allowedLogs == null ? other$allowedLogs != null : !((Object)this$allowedLogs).equals(other$allowedLogs)) {
            return false;
        }
        List<String> this$deniedLogs = this.getDeniedLogs();
        List<String> other$deniedLogs = other.getDeniedLogs();
        if (this$deniedLogs == null ? other$deniedLogs != null : !((Object)this$deniedLogs).equals(other$deniedLogs)) {
            return false;
        }
        List<String> this$allowedLeaves = this.getAllowedLeaves();
        List<String> other$allowedLeaves = other.getAllowedLeaves();
        if (this$allowedLeaves == null ? other$allowedLeaves != null : !((Object)this$allowedLeaves).equals(other$allowedLeaves)) {
            return false;
        }
        List<String> this$allowedNonDecayLeaves = this.getAllowedNonDecayLeaves();
        List<String> other$allowedNonDecayLeaves = other.getAllowedNonDecayLeaves();
        if (this$allowedNonDecayLeaves == null ? other$allowedNonDecayLeaves != null : !((Object)this$allowedNonDecayLeaves).equals(other$allowedNonDecayLeaves)) {
            return false;
        }
        List<String> this$deniedLeaves = this.getDeniedLeaves();
        List<String> other$deniedLeaves = other.getDeniedLeaves();
        if (this$deniedLeaves == null ? other$deniedLeaves != null : !((Object)this$deniedLeaves).equals(other$deniedLeaves)) {
            return false;
        }
        BreakMode this$breakMode = this.getBreakMode();
        BreakMode other$breakMode = other.getBreakMode();
        if (this$breakMode == null ? other$breakMode != null : !((Object)((Object)this$breakMode)).equals((Object)other$breakMode)) {
            return false;
        }
        DetectionMode this$detectionMode = this.getDetectionMode();
        DetectionMode other$detectionMode = other.getDetectionMode();
        if (this$detectionMode == null ? other$detectionMode != null : !((Object)((Object)this$detectionMode)).equals((Object)other$detectionMode)) {
            return false;
        }
        MaxSizeAction this$maxSizeAction = this.getMaxSizeAction();
        MaxSizeAction other$maxSizeAction = other.getMaxSizeAction();
        if (this$maxSizeAction == null ? other$maxSizeAction != null : !((Object)((Object)this$maxSizeAction)).equals((Object)other$maxSizeAction)) {
            return false;
        }
        BreakOrder this$breakOrder = this.getBreakOrder();
        BreakOrder other$breakOrder = other.getBreakOrder();
        if (this$breakOrder == null ? other$breakOrder != null : !((Object)((Object)this$breakOrder)).equals((Object)other$breakOrder)) {
            return false;
        }
        List<String> this$allowedAdjacentBlocks = this.getAllowedAdjacentBlocks();
        List<String> other$allowedAdjacentBlocks = other.getAllowedAdjacentBlocks();
        if (this$allowedAdjacentBlocks == null ? other$allowedAdjacentBlocks != null : !((Object)this$allowedAdjacentBlocks).equals(other$allowedAdjacentBlocks)) {
            return false;
        }
        AdjacentStopMode this$adjacentStopMode = this.getAdjacentStopMode();
        AdjacentStopMode other$adjacentStopMode = other.getAdjacentStopMode();
        if (this$adjacentStopMode == null ? other$adjacentStopMode != null : !((Object)((Object)this$adjacentStopMode)).equals((Object)other$adjacentStopMode)) {
            return false;
        }
        Set<IBlock> this$deniedLeavesCache = this.getDeniedLeavesCache();
        Set<IBlock> other$deniedLeavesCache = other.getDeniedLeavesCache();
        if (this$deniedLeavesCache == null ? other$deniedLeavesCache != null : !((Object)this$deniedLeavesCache).equals(other$deniedLeavesCache)) {
            return false;
        }
        Set<IBlock> this$deniedLogsCache = this.getDeniedLogsCache();
        Set<IBlock> other$deniedLogsCache = other.getDeniedLogsCache();
        if (this$deniedLogsCache == null ? other$deniedLogsCache != null : !((Object)this$deniedLogsCache).equals(other$deniedLogsCache)) {
            return false;
        }
        Set<IBlock> this$allowedLeavesCache = this.getAllowedLeavesCache();
        Set<IBlock> other$allowedLeavesCache = other.getAllowedLeavesCache();
        if (this$allowedLeavesCache == null ? other$allowedLeavesCache != null : !((Object)this$allowedLeavesCache).equals(other$allowedLeavesCache)) {
            return false;
        }
        Set<IBlock> this$allowedNonDecayLeavesCache = this.getAllowedNonDecayLeavesCache();
        Set<IBlock> other$allowedNonDecayLeavesCache = other.getAllowedNonDecayLeavesCache();
        if (this$allowedNonDecayLeavesCache == null ? other$allowedNonDecayLeavesCache != null : !((Object)this$allowedNonDecayLeavesCache).equals(other$allowedNonDecayLeavesCache)) {
            return false;
        }
        Set<IBlock> this$allowedLogsCache = this.getAllowedLogsCache();
        Set<IBlock> other$allowedLogsCache = other.getAllowedLogsCache();
        if (this$allowedLogsCache == null ? other$allowedLogsCache != null : !((Object)this$allowedLogsCache).equals(other$allowedLogsCache)) {
            return false;
        }
        Set<IBlock> this$allowedAdjacentBlocksCache = this.getAllowedAdjacentBlocksCache();
        Set<IBlock> other$allowedAdjacentBlocksCache = other.getAllowedAdjacentBlocksCache();
        if (this$allowedAdjacentBlocksCache == null ? other$allowedAdjacentBlocksCache != null : !((Object)this$allowedAdjacentBlocksCache).equals(other$allowedAdjacentBlocksCache)) {
            return false;
        }
        Set<IBlock> this$adjacentBlocksBaseCache = this.getAdjacentBlocksBaseCache();
        Set<IBlock> other$adjacentBlocksBaseCache = other.getAdjacentBlocksBaseCache();
        if (this$adjacentBlocksBaseCache == null ? other$adjacentBlocksBaseCache != null : !((Object)this$adjacentBlocksBaseCache).equals(other$adjacentBlocksBaseCache)) {
            return false;
        }
        Set<IBlock> this$defaultLogsBlocksCache = this.getDefaultLogsBlocksCache();
        Set<IBlock> other$defaultLogsBlocksCache = other.getDefaultLogsBlocksCache();
        return !(this$defaultLogsBlocksCache == null ? other$defaultLogsBlocksCache != null : !((Object)this$defaultLogsBlocksCache).equals(other$defaultLogsBlocksCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxScanSize();
        result = result * 59 + this.getMaxSize();
        result = result * 59 + this.getMinimumLeavesAroundRequired();
        result = result * 59 + (this.isIncludePersistentLeavesInRequiredCount() ? 79 : 97);
        result = result * 59 + (this.isTreeBreaking() ? 79 : 97);
        result = result * 59 + (this.isLeavesBreaking() ? 79 : 97);
        result = result * 59 + this.getLeavesBreakingForceRadius();
        result = result * 59 + (this.isAllowMixedLogs() ? 79 : 97);
        result = result * 59 + (this.isBreakNetherTreeWarts() ? 79 : 97);
        result = result * 59 + (this.isInstantlyBreakWarts() ? 79 : 97);
        result = result * 59 + this.getSearchAreaRadius();
        List<String> $allowedLogs = this.getAllowedLogs();
        result = result * 59 + ($allowedLogs == null ? 43 : ((Object)$allowedLogs).hashCode());
        List<String> $deniedLogs = this.getDeniedLogs();
        result = result * 59 + ($deniedLogs == null ? 43 : ((Object)$deniedLogs).hashCode());
        List<String> $allowedLeaves = this.getAllowedLeaves();
        result = result * 59 + ($allowedLeaves == null ? 43 : ((Object)$allowedLeaves).hashCode());
        List<String> $allowedNonDecayLeaves = this.getAllowedNonDecayLeaves();
        result = result * 59 + ($allowedNonDecayLeaves == null ? 43 : ((Object)$allowedNonDecayLeaves).hashCode());
        List<String> $deniedLeaves = this.getDeniedLeaves();
        result = result * 59 + ($deniedLeaves == null ? 43 : ((Object)$deniedLeaves).hashCode());
        BreakMode $breakMode = this.getBreakMode();
        result = result * 59 + ($breakMode == null ? 43 : ((Object)((Object)$breakMode)).hashCode());
        DetectionMode $detectionMode = this.getDetectionMode();
        result = result * 59 + ($detectionMode == null ? 43 : ((Object)((Object)$detectionMode)).hashCode());
        MaxSizeAction $maxSizeAction = this.getMaxSizeAction();
        result = result * 59 + ($maxSizeAction == null ? 43 : ((Object)((Object)$maxSizeAction)).hashCode());
        BreakOrder $breakOrder = this.getBreakOrder();
        result = result * 59 + ($breakOrder == null ? 43 : ((Object)((Object)$breakOrder)).hashCode());
        List<String> $allowedAdjacentBlocks = this.getAllowedAdjacentBlocks();
        result = result * 59 + ($allowedAdjacentBlocks == null ? 43 : ((Object)$allowedAdjacentBlocks).hashCode());
        AdjacentStopMode $adjacentStopMode = this.getAdjacentStopMode();
        result = result * 59 + ($adjacentStopMode == null ? 43 : ((Object)((Object)$adjacentStopMode)).hashCode());
        Set<IBlock> $deniedLeavesCache = this.getDeniedLeavesCache();
        result = result * 59 + ($deniedLeavesCache == null ? 43 : ((Object)$deniedLeavesCache).hashCode());
        Set<IBlock> $deniedLogsCache = this.getDeniedLogsCache();
        result = result * 59 + ($deniedLogsCache == null ? 43 : ((Object)$deniedLogsCache).hashCode());
        Set<IBlock> $allowedLeavesCache = this.getAllowedLeavesCache();
        result = result * 59 + ($allowedLeavesCache == null ? 43 : ((Object)$allowedLeavesCache).hashCode());
        Set<IBlock> $allowedNonDecayLeavesCache = this.getAllowedNonDecayLeavesCache();
        result = result * 59 + ($allowedNonDecayLeavesCache == null ? 43 : ((Object)$allowedNonDecayLeavesCache).hashCode());
        Set<IBlock> $allowedLogsCache = this.getAllowedLogsCache();
        result = result * 59 + ($allowedLogsCache == null ? 43 : ((Object)$allowedLogsCache).hashCode());
        Set<IBlock> $allowedAdjacentBlocksCache = this.getAllowedAdjacentBlocksCache();
        result = result * 59 + ($allowedAdjacentBlocksCache == null ? 43 : ((Object)$allowedAdjacentBlocksCache).hashCode());
        Set<IBlock> $adjacentBlocksBaseCache = this.getAdjacentBlocksBaseCache();
        result = result * 59 + ($adjacentBlocksBaseCache == null ? 43 : ((Object)$adjacentBlocksBaseCache).hashCode());
        Set<IBlock> $defaultLogsBlocksCache = this.getDefaultLogsBlocksCache();
        result = result * 59 + ($defaultLogsBlocksCache == null ? 43 : ((Object)$defaultLogsBlocksCache).hashCode());
        return result;
    }

    public String toString() {
        return "TreeConfiguration(allowedLogs=" + this.getAllowedLogs() + ", deniedLogs=" + this.getDeniedLogs() + ", allowedLeaves=" + this.getAllowedLeaves() + ", allowedNonDecayLeaves=" + this.getAllowedNonDecayLeaves() + ", deniedLeaves=" + this.getDeniedLeaves() + ", breakMode=" + this.getBreakMode() + ", detectionMode=" + this.getDetectionMode() + ", maxScanSize=" + this.getMaxScanSize() + ", maxSize=" + this.getMaxSize() + ", maxSizeAction=" + this.getMaxSizeAction() + ", breakOrder=" + this.getBreakOrder() + ", minimumLeavesAroundRequired=" + this.getMinimumLeavesAroundRequired() + ", includePersistentLeavesInRequiredCount=" + this.isIncludePersistentLeavesInRequiredCount() + ", treeBreaking=" + this.isTreeBreaking() + ", leavesBreaking=" + this.isLeavesBreaking() + ", leavesBreakingForceRadius=" + this.getLeavesBreakingForceRadius() + ", allowMixedLogs=" + this.isAllowMixedLogs() + ", breakNetherTreeWarts=" + this.isBreakNetherTreeWarts() + ", instantlyBreakWarts=" + this.isInstantlyBreakWarts() + ", searchAreaRadius=" + this.getSearchAreaRadius() + ", allowedAdjacentBlocks=" + this.getAllowedAdjacentBlocks() + ", adjacentStopMode=" + this.getAdjacentStopMode() + ", deniedLeavesCache=" + this.getDeniedLeavesCache() + ", deniedLogsCache=" + this.getDeniedLogsCache() + ", allowedLeavesCache=" + this.getAllowedLeavesCache() + ", allowedNonDecayLeavesCache=" + this.getAllowedNonDecayLeavesCache() + ", allowedLogsCache=" + this.getAllowedLogsCache() + ", allowedAdjacentBlocksCache=" + this.getAllowedAdjacentBlocksCache() + ", adjacentBlocksBaseCache=" + this.getAdjacentBlocksBaseCache() + ", defaultLogsBlocksCache=" + this.getDefaultLogsBlocksCache() + ")";
    }
}

