/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.tree;

import fr.raksrinana.fallingtree.common.tree.TreePart;
import fr.raksrinana.fallingtree.common.tree.TreePartType;
import fr.raksrinana.fallingtree.common.wrapper.IBlockPos;
import fr.raksrinana.fallingtree.common.wrapper.ILevel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Tree {
    @NotNull
    private final ILevel level;
    @NotNull
    private final IBlockPos hitPos;
    private final Set<TreePart> parts = new LinkedHashSet<TreePart>();
    private final Map<TreePartType, Integer> partCounts = new LinkedHashMap<TreePartType, Integer>();

    public void addPart(@NotNull TreePart treePart) {
        this.parts.add(treePart);
        this.partCounts.compute(treePart.treePartType(), (key, value) -> {
            if (Objects.isNull(value)) {
                return 1;
            }
            return value + 1;
        });
    }

    public void removePartsHigherThan(int y, @NotNull TreePartType partType) {
        this.parts.removeIf(part -> {
            if (part.treePartType() == partType && part.blockPos().getY() > y) {
                this.decrementPartCount(partType);
                return true;
            }
            return false;
        });
    }

    public int getBreakableCount() {
        return Arrays.stream(TreePartType.values()).filter(TreePartType::isBreakable).mapToInt(this::getPartCount).sum();
    }

    private int getPartCount(@NotNull TreePartType treePartType) {
        return this.partCounts.computeIfAbsent(treePartType, key -> 0);
    }

    public int getSize() {
        return this.partCounts.values().stream().mapToInt(i -> i).sum();
    }

    private void decrementPartCount(@NotNull TreePartType partType) {
        this.partCounts.computeIfPresent(partType, (type, count) -> Math.max(0, count - 1));
    }

    @NotNull
    public Optional<TreePart> getLastSequencePart() {
        return this.getParts().stream().max(Comparator.comparingInt(TreePart::sequence));
    }

    @NotNull
    public Collection<TreePart> getLogs() {
        return this.getParts().stream().filter(part -> part.treePartType() == TreePartType.LOG).collect(Collectors.toSet());
    }

    @NotNull
    public Collection<TreePart> getBreakableParts() {
        return this.getParts().stream().filter(part -> part.treePartType().isBreakable()).collect(Collectors.toSet());
    }

    public int getLogCount() {
        return this.getPartCount(TreePartType.LOG);
    }

    @NotNull
    public Optional<IBlockPos> getTopMostLog() {
        return this.getLogs().stream().map(TreePart::blockPos).max(Comparator.comparingInt(IBlockPos::getY));
    }

    @NotNull
    private Optional<IBlockPos> getTopMostPart() {
        return this.getParts().stream().map(TreePart::blockPos).max(Comparator.comparingInt(IBlockPos::getY));
    }

    @NotNull
    public Collection<TreePart> getWarts() {
        return this.getParts().stream().filter(part -> part.treePartType() == TreePartType.NETHER_WART).collect(Collectors.toSet());
    }

    public Tree(@NotNull ILevel level, @NotNull IBlockPos hitPos) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (hitPos == null) {
            throw new NullPointerException("hitPos is marked non-null but is null");
        }
        this.level = level;
        this.hitPos = hitPos;
    }

    @NotNull
    public ILevel getLevel() {
        return this.level;
    }

    @NotNull
    public IBlockPos getHitPos() {
        return this.hitPos;
    }

    public Set<TreePart> getParts() {
        return this.parts;
    }
}

