/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.event;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.config.enums.BreakMode;
import fr.raksrinana.fallingtree.common.tree.BreakTreeResult;
import fr.raksrinana.fallingtree.fabric.common.wrapper.BlockPosWrapper;
import fr.raksrinana.fallingtree.fabric.common.wrapper.LevelWrapper;
import fr.raksrinana.fallingtree.fabric.common.wrapper.PlayerWrapper;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class BlockBreakListener
implements PlayerBlockBreakEvents.Before {
    @NotNull
    private final FallingTreeCommon<?> mod;

    public boolean beforeBlockBreak(class_1937 level, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        PlayerWrapper wrappedPlayer = new PlayerWrapper(player);
        LevelWrapper wrappedLevel = new LevelWrapper(level);
        BlockPosWrapper wrappedPos = new BlockPosWrapper(blockPos);
        Optional<BreakTreeResult> result = this.mod.getTreeHandler().breakTree(wrappedLevel, wrappedPlayer, wrappedPos);
        if (result.isEmpty()) {
            return true;
        }
        return switch (result.get().breakMode()) {
            default -> throw new IncompatibleClassChangeError();
            case BreakMode.INSTANTANEOUS -> {
                if (!result.get().shouldCancel()) {
                    yield true;
                }
                yield false;
            }
            case BreakMode.SHIFT_DOWN -> false;
        };
    }

    public BlockBreakListener(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

