/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Penguin
extends Animal
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> PREGNANT = SynchedEntityData.m_135353_(Penguin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42530_});
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public Penguin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.4f, 1.0f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 20);
        this.f_19793_ = 1.0f;
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new PenguinMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new PenguinSearchForCodItemGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new PenguinRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new PenguinRandomSwimmingGoal(this, 1.0, 120));
        this.f_21345_.m_25352_(8, (Goal)new PenguinFillBarrelGoal(this, 1.0, 30, 20));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new PenguinAttackTargetGoal<Cod>(this, Cod.class, false));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new PenguinPathNavigation(this, pLevel);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)ModEntityTypes.PENGUIN.get()).m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public boolean isPregnant() {
        return (Boolean)this.f_19804_.m_135370_(PREGNANT);
    }

    public void setPregnant(boolean isPregnant) {
        this.f_19804_.m_135381_(PREGNANT, (Object)isPregnant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREGNANT, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsPregnant", this.isPregnant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setPregnant(pCompound.m_128471_("IsPregnant"));
    }

    public void m_27563_(ServerLevel level, Animal otherParent) {
        ServerPlayer serverplayer = this.m_27592_();
        if (serverplayer == null && otherParent.m_27592_() != null) {
            serverplayer = otherParent.m_27592_();
        }
        if (serverplayer != null) {
            serverplayer.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)this, otherParent, null);
        }
        this.m_146762_(6000);
        otherParent.m_146762_(6000);
        this.m_27594_();
        otherParent.m_27594_();
        level.m_7605_((Entity)this, (byte)18);
        this.setPregnant(true);
        if (level.m_46469_().m_46207_(GameRules.f_46135_)) {
            level.m_7967_((Entity)new ExperienceOrb((Level)level, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
        }
    }

    protected void m_142669_() {
        super.m_142669_();
        if (!this.m_6162_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)ModItems.PENGUIN_FEATHER.get(), 1);
        }
    }

    public void m_8107_() {
        if (this.isPregnant() && this.f_19796_.nextInt(3000) == 0 && !this.f_19853_.f_46443_) {
            ServerLevel level = (ServerLevel)this.f_19853_;
            this.setPregnant(false);
            Penguin penguin = (Penguin)((EntityType)ModEntityTypes.PENGUIN.get()).m_20615_((Level)level);
            penguin.m_6863_(true);
            penguin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            level.m_47205_((Entity)penguin);
            level.m_7605_((Entity)this, (byte)18);
        }
        if (this.f_19853_.m_45976_(Penguin.class, this.m_142469_().m_82400_(20.0)).size() > 4) {
            for (Player player : this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82400_(10.0))) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0, true, true));
            }
        }
        super.m_8107_();
    }

    public boolean m_7066_(ItemStack pItemstack) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)pItemstack);
        if (!this.m_6844_(equipmentslot).m_41619_() || this.m_6162_()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(pItemstack);
    }

    public boolean m_7252_(ItemStack pStack) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() && pStack.m_150930_(Items.f_42526_) && !this.m_6162_();
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            int count = itemstack.m_41613_();
            if (count > 1) {
                this.dropItemStack(itemstack.m_41620_(count - 1));
            }
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
            pItemEntity.m_146870_();
        }
    }

    private void dropItemStack(ItemStack pStack) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), pStack);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.PENGUIN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.PENGUIN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.PENGUIN_DEATH.get();
    }

    private boolean babyIsNearAdult() {
        Iterator iterator;
        if (this.m_6162_() && (iterator = this.f_19853_.m_45976_(Penguin.class, this.m_142469_().m_82377_(2.0, 5.0, 2.0)).iterator()).hasNext()) {
            Penguin penguin = (Penguin)((Object)iterator.next());
            return !penguin.m_6162_();
        }
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.swim", Boolean.valueOf(true)));
        } else if (this.m_6162_()) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.baby_penguin.waddle", Boolean.valueOf(true)));
            } else if (this.babyIsNearAdult()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.baby_penguin.huddle", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.baby_penguin.idle", Boolean.valueOf(true)));
            }
        } else if (event.isMoving()) {
            if (this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60713_(Blocks.f_50126_) && !this.m_27593_() && !this.isPregnant()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.slide", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.waddle", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class PenguinMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Penguin penguin;

        public PenguinMeleeAttackGoal(Penguin pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.penguin = pMob;
        }

        public boolean m_8036_() {
            if (!this.penguin.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || this.penguin.m_6162_() || this.penguin.isPregnant()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class PenguinSearchForCodItemGoal
    extends Goal {
        private final Penguin penguin;

        public PenguinSearchForCodItemGoal(Penguin penguin) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.penguin = penguin;
        }

        public boolean m_8036_() {
            if (!this.penguin.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || this.penguin.m_6162_() || this.penguin.isPregnant()) {
                return false;
            }
            List list = this.penguin.f_19853_.m_6443_(ItemEntity.class, this.penguin.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_150930_(Items.f_42526_));
            return !list.isEmpty() && this.penguin.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        public void m_8037_() {
            List list = this.penguin.f_19853_.m_6443_(ItemEntity.class, this.penguin.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_150930_(Items.f_42526_));
            ItemStack itemstack = this.penguin.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                this.penguin.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }

        public void m_8056_() {
            List list = this.penguin.f_19853_.m_6443_(ItemEntity.class, this.penguin.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_150930_(Items.f_42526_));
            if (!list.isEmpty()) {
                this.penguin.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }
    }

    static class PenguinRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        private final Penguin penguin;

        public PenguinRandomStrollGoal(Penguin pMob, double pSpeedModifier) {
            super((PathfinderMob)pMob, pSpeedModifier);
            this.penguin = pMob;
        }

        public boolean m_8036_() {
            if (!this.penguin.m_21205_().m_41619_()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class PenguinRandomSwimmingGoal
    extends RandomSwimmingGoal {
        private final Penguin penguin;

        public PenguinRandomSwimmingGoal(Penguin pMob, double pSpeedModifier, int pInterval) {
            super((PathfinderMob)pMob, pSpeedModifier, pInterval);
            this.penguin = pMob;
        }

        public boolean m_8036_() {
            if (this.penguin.m_6162_() || this.penguin.isPregnant() || !this.penguin.m_21205_().m_41619_()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class PenguinFillBarrelGoal
    extends MoveToBlockGoal {
        private final Penguin penguin;
        private boolean reachedTarget;

        public PenguinFillBarrelGoal(Penguin penguin, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)penguin, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.penguin = penguin;
        }

        public boolean m_8036_() {
            if (this.penguin.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || this.penguin.m_6162_() || this.penguin.isPregnant()) {
                return false;
            }
            return super.m_8036_();
        }

        public double m_8052_() {
            return 2.0;
        }

        public void m_8037_() {
            Level level;
            BlockEntity blockEntity;
            BlockPos blockpos = this.m_6669_();
            if (!blockpos.m_203195_((Position)this.f_25598_.m_20182_(), this.m_8052_())) {
                this.reachedTarget = false;
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
                }
            } else {
                this.reachedTarget = true;
                --this.f_25601_;
            }
            if (this.reachedTarget && !this.penguin.m_21205_().m_41619_() && (blockEntity = (level = this.penguin.f_19853_).m_7702_(this.f_25602_)) instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
                this.onReachedTarget(level, barrel);
                this.reachedTarget = false;
            }
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            return blockstate.m_60713_(Blocks.f_50618_);
        }

        protected void onReachedTarget(Level level, BarrelBlockEntity barrel) {
            for (int i = 0; i < barrel.m_6643_(); ++i) {
                if (!this.canPlaceItem(barrel, i, this.penguin.m_21205_())) continue;
                this.penguin.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                level.m_5594_(null, this.f_25602_, SoundEvents.f_11760_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                break;
            }
        }

        boolean canPlaceItem(BarrelBlockEntity barrel, int index, ItemStack stack) {
            int amount;
            if (barrel.m_8020_(index).m_41619_()) {
                barrel.m_6836_(index, new ItemStack((ItemLike)stack.m_41720_()));
                return true;
            }
            if (barrel.m_8020_(index).m_150930_(stack.m_41720_()) && (amount = barrel.m_8020_(index).m_41613_()) < 64) {
                barrel.m_6836_(index, new ItemStack((ItemLike)stack.m_41720_(), amount + 1));
                return true;
            }
            return false;
        }

        protected boolean m_25625_() {
            return this.reachedTarget;
        }
    }

    static class PenguinAttackTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final Penguin penguin;

        public PenguinAttackTargetGoal(Penguin pMob, Class<T> pTargetType, boolean pMustSee) {
            super((Mob)pMob, pTargetType, pMustSee);
            this.penguin = pMob;
        }

        public boolean m_8036_() {
            if (this.penguin.m_6162_() || this.penguin.isPregnant() || !this.penguin.m_21205_().m_41619_()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class PenguinPathNavigation
    extends WaterBoundPathNavigation {
        public PenguinPathNavigation(Penguin penguin, Level level) {
            super((Mob)penguin, level);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_149222_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_149222_);
        }

        public boolean m_6342_(BlockPos p_149224_) {
            return !this.f_26495_.m_8055_(p_149224_.m_7495_()).m_60795_();
        }
    }
}

