/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Squirrel
extends Animal
implements IAnimatable {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Squirrel.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_TRUSTING = SynchedEntityData.m_135353_(Squirrel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WALNUT.get()});
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public Squirrel(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.4f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPT_INGREDIENT, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SquirrelSearchForSaplingsGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new SquirrelPlantSaplingGoal(this, 1.0, 8, 4));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_TRUSTING, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Trusting", this.isTrusting());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTrusting(pCompound.m_128471_("Trusting"));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pMob) {
        return (AgeableMob)((EntityType)ModEntityTypes.SQUIRREL.get()).m_20615_((Level)pLevel);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_42784_);
    }

    boolean isTrusting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TRUSTING);
    }

    private void setTrusting(boolean pTrusting) {
        this.f_19804_.m_135381_(DATA_TRUSTING, (Object)pTrusting);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!this.isTrusting() && TEMPT_INGREDIENT.test(itemstack)) {
            this.m_142075_(pPlayer, pHand, itemstack);
            if (!this.f_19853_.f_46443_) {
                if (this.f_19796_.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                    this.setTrusting(true);
                    this.spawnTrustingParticles(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)41);
                } else {
                    this.spawnTrustingParticles(false);
                    this.f_19853_.m_7605_((Entity)this, (byte)40);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_7822_(byte pId) {
        if (pId == 41) {
            this.spawnTrustingParticles(true);
        } else if (pId == 40) {
            this.spawnTrustingParticles(false);
        } else {
            super.m_7822_(pId);
        }
    }

    private void spawnTrustingParticles(boolean isTrusting) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!isTrusting) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double x = this.f_19796_.nextGaussian() * 0.02;
            double y = this.f_19796_.nextGaussian() * 0.02;
            double z = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), x, y, z);
        }
    }

    public boolean m_7066_(ItemStack pItemstack) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)pItemstack);
        if (!this.m_6844_(equipmentslot).m_41619_() || this.m_6162_() || !this.isTrusting()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(pItemstack);
    }

    public boolean m_7252_(ItemStack pStack) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() && pStack.m_204117_(ItemTags.f_13180_) && !this.m_6162_() && this.isTrusting();
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            int count = itemstack.m_41613_();
            if (count > 1) {
                this.dropItemStack(itemstack.m_41620_(count - 1));
            }
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
            pItemEntity.m_146870_();
        }
    }

    private void dropItemStack(ItemStack pStack) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), pStack);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte flag = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flag = pClimbing ? (byte)(flag | 1) : (byte)(flag & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flag);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_6573_(Player pPlayer) {
        return this.isTrusting();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.SQUIRREL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.SQUIRREL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.SQUIRREL_DEATH.get();
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.isClimbing()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squirrel.climb", Boolean.valueOf(true)));
        } else if (event.isMoving() && this.m_20096_() || this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squirrel.run", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.squirrel.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class SquirrelSearchForSaplingsGoal
    extends Goal {
        private final Squirrel squirrel;

        public SquirrelSearchForSaplingsGoal(Squirrel squirrel) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.squirrel = squirrel;
        }

        public boolean m_8036_() {
            if (!this.squirrel.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || this.squirrel.m_6162_() || !this.squirrel.isTrusting()) {
                return false;
            }
            List list = this.squirrel.f_19853_.m_6443_(ItemEntity.class, this.squirrel.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_204117_(ItemTags.f_13180_));
            return !list.isEmpty() && this.squirrel.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        public void m_8037_() {
            List list = this.squirrel.f_19853_.m_6443_(ItemEntity.class, this.squirrel.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_204117_(ItemTags.f_13180_));
            ItemStack itemstack = this.squirrel.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                this.squirrel.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }

        public void m_8056_() {
            List list = this.squirrel.f_19853_.m_6443_(ItemEntity.class, this.squirrel.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_204117_(ItemTags.f_13180_));
            if (!list.isEmpty()) {
                this.squirrel.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }
    }

    static class SquirrelPlantSaplingGoal
    extends MoveToBlockGoal {
        private final Squirrel squirrel;
        private boolean reachedTarget;

        public SquirrelPlantSaplingGoal(Squirrel squirrel, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)squirrel, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.squirrel = squirrel;
        }

        public boolean m_8036_() {
            if (this.squirrel.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || this.squirrel.m_6162_() || !this.squirrel.isTrusting()) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8037_() {
            Level level;
            BlockPos blockpos = this.m_6669_();
            if (!blockpos.m_203195_((Position)this.f_25598_.m_20182_(), this.m_8052_())) {
                this.reachedTarget = false;
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
                }
            } else {
                this.reachedTarget = true;
                --this.f_25601_;
            }
            if (this.reachedTarget && !this.squirrel.m_21205_().m_41619_() && (level = this.squirrel.f_19853_).m_8055_(this.f_25602_).m_204336_(BlockTags.f_144274_)) {
                this.onReachedTarget(level);
                this.reachedTarget = false;
            }
        }

        public double m_8052_() {
            return 1.5;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockState blockstate = pLevel.m_8055_(pPos);
            return blockstate.m_204336_(BlockTags.f_144274_) && pLevel.m_8055_(pPos.m_7494_()).m_60795_();
        }

        protected void onReachedTarget(Level level) {
            Item item = this.squirrel.m_21205_().m_41720_();
            if (item instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                level.m_46597_(this.f_25602_.m_7494_(), item2.m_40614_().m_49966_());
                level.m_5594_(null, this.f_25602_, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                this.squirrel.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }

        protected boolean m_25625_() {
            return this.reachedTarget;
        }
    }
}

