/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.server;

import com.glisco.deathlog.DeathLogCommon;
import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.network.DeathLogPackets;
import com.glisco.deathlog.server.ServerDeathLogStorage;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class DeathLogServer
implements DedicatedServerModInitializer {
    private static final DynamicCommandExceptionType INVALID_INDEX = new DynamicCommandExceptionType(o -> new class_2585("No DeathInfo found for index " + o));
    private static final DynamicCommandExceptionType NO_PLAYER_FOR_PROFILE = new DynamicCommandExceptionType(o -> new class_2585("Player " + ((GameProfile)o).getName() + " is not online"));
    private static final SimpleCommandExceptionType NO_DEATHS = new SimpleCommandExceptionType((Message)new class_2585("No DeathInfo found"));
    private static ServerDeathLogStorage storage;

    public void onInitializeServer() {
        storage = new ServerDeathLogStorage();
        DeathLogCommon.setStorage(storage);
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"deathlog").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(DeathLogServer.hasPermission("deathlog.list"))).then(((RequiredArgumentBuilder)DeathLogServer.createProfileArgument().executes(context -> this.executeList((CommandContext<class_2168>)context, null))).then(class_2170.method_9244((String)"search_term", (ArgumentType)StringArgumentType.string()).executes(context -> this.executeList((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"search_term"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"view").requires(DeathLogServer.hasPermission("deathlog.view"))).then(DeathLogServer.createProfileArgument().executes(context -> {
            DeathLogPackets.Server.openScreen(DeathLogServer.getProfile((CommandContext<class_2168>)context).getId(), ((class_2168)context.getSource()).method_9207());
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"restore").requires(DeathLogServer.hasPermission("deathlog.restore"))).then(((RequiredArgumentBuilder)DeathLogServer.createProfileArgument().then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int index = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            return DeathLogServer.executeRestore((CommandContext<class_2168>)context, index);
        }))).then(class_2170.method_9247((String)"latest").executes(DeathLogServer::executeRestoreLatest))))));
        DeathLogPackets.Server.registerDedicatedListeners();
    }

    private int executeList(CommandContext<class_2168> context, @Nullable String filter) throws CommandSyntaxException {
        GameProfile profile = DeathLogServer.getProfile(context);
        List<DeathInfo> deathInfoList = DeathLogServer.getStorage().getDeathInfoList(profile.getId());
        if (filter != null) {
            deathInfoList = deathInfoList.stream().filter(info -> info.createSearchString().contains(filter.toLowerCase())).toList();
        }
        int infoListSize = deathInfoList.size();
        for (int i = 0; i < infoListSize; ++i) {
            DeathInfo deathInfo = deathInfoList.get(i);
            Iterator<class_2561> leftText = deathInfo.getLeftColumnText().iterator();
            Iterator<class_2561> rightText = deathInfo.getRightColumnText().iterator();
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(""), false);
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("\u00a77-- \u00a7aBegin \u00a7bDeath Info Entry [" + i + "]\u00a77--"), false);
            while (leftText.hasNext()) {
                ((class_2168)context.getSource()).method_9226((class_2561)((class_5250)leftText.next()).method_10852((class_2561)new class_2585(": ")).method_10852((class_2561)((class_5250)rightText.next()).method_27692(class_124.field_1068)), false);
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("\u00a77-- \u00a7cEnd \u00a7bDeath Info Entry [" + i + "]\u00a77--"), false);
        }
        if (infoListSize > 0) {
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(""), false);
        }
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Queried \u00a7b" + infoListSize + "\u00a7r death info entries for player ").method_27693("\u00a7b" + profile.getName()), false);
        return infoListSize;
    }

    private static Predicate<class_2168> hasPermission(String node) {
        return DeathLogCommon.usePermissions() ? Permissions.require((String)node, (int)4) : serverCommandSource -> serverCommandSource.method_9259(4);
    }

    public static boolean hasPermission(class_3222 player, String node) {
        return DeathLogCommon.usePermissions() ? Permissions.check((class_1297)player, (String)node, (int)4) : player.method_5687(4);
    }

    private static int executeRestoreLatest(CommandContext<class_2168> context) throws CommandSyntaxException {
        DeathLogServer.restore(context, deathInfos -> deathInfos.size() - 1, index -> NO_DEATHS.create());
        return 0;
    }

    private static int executeRestore(CommandContext<class_2168> context, int index) throws CommandSyntaxException {
        DeathLogServer.restore(context, deathInfos -> index, arg_0 -> ((DynamicCommandExceptionType)INVALID_INDEX).create(arg_0));
        return 0;
    }

    private static void restore(CommandContext<class_2168> context, Function<List<DeathInfo>, Integer> indexProvider, Function<Integer, CommandSyntaxException> exceptionProvider) throws CommandSyntaxException {
        GameProfile targetProfile = DeathLogServer.getProfile(context);
        List<DeathInfo> deathInfoList = DeathLogServer.getStorage().getDeathInfoList(targetProfile.getId());
        class_3222 targetPlayer = ((class_2168)context.getSource()).method_9211().method_3760().method_14602(targetProfile.getId());
        if (targetPlayer == null) {
            throw NO_PLAYER_FOR_PROFILE.create((Object)targetProfile);
        }
        int index = indexProvider.apply(deathInfoList);
        if (deathInfoList.isEmpty() || index > deathInfoList.size() - 1) {
            throw exceptionProvider.apply(index);
        }
        deathInfoList.get(index).restore(targetPlayer);
    }

    private static GameProfile getProfile(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profileArgument = class_2191.method_9330(context, (String)"player");
        return (GameProfile)profileArgument.iterator().next();
    }

    private static RequiredArgumentBuilder<class_2168, class_2191.class_2192> createProfileArgument() {
        return class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerManager.method_14571().stream().map(player -> player.method_7334().getName()), (SuggestionsBuilder)builder);
        });
    }

    public static ServerDeathLogStorage getStorage() {
        return storage;
    }
}

