/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.client.book.page.PageQuest;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookEntry
extends AbstractReadStateHolder
implements Comparable<BookEntry> {
    private String name;
    private String category;
    private String flag;
    @SerializedName(value="icon")
    private String iconRaw;
    private boolean priority = false;
    private boolean secret = false;
    @SerializedName(value="read_by_default")
    private boolean readByDefault = false;
    private BookPage[] pages;
    private String advancement;
    private String turnin;
    private int sortnum;
    @SerializedName(value="entry_color")
    private String entryColorRaw;
    @SerializedName(value="extra_recipe_mappings")
    private Map<String, Integer> extraRecipeMappings;
    private transient ResourceLocation id;
    private transient Book book;
    private transient Book trueProvider;
    private transient BookCategory lcategory = null;
    private transient BookIcon icon = null;
    private final transient List<BookPage> realPages = new ArrayList<BookPage>();
    private final transient List<ItemStackUtil.StackWrapper> relevantStacks = new LinkedList<ItemStackUtil.StackWrapper>();
    private transient boolean locked;
    private transient int entryColor;
    private transient boolean built;
    private static final List<BookPage> NO_PAGE = ImmutableList.of((Object)new PageEmpty());

    public MutableComponent getName() {
        return this.book.i18n ? new TranslatableComponent(this.name) : new TextComponent(this.name);
    }

    public List<BookPage> getPages() {
        List<BookPage> pages = !this.getBook().advancementsEnabled() ? this.realPages : this.realPages.stream().filter(BookPage::isPageUnlocked).collect(Collectors.toList());
        return pages.isEmpty() ? NO_PAGE : pages;
    }

    public int getPageFromAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.anchor)) continue;
            return i;
        }
        return -1;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public BookIcon getIcon() {
        if (this.icon == null) {
            this.icon = BookIcon.from(this.iconRaw);
        }
        return this.icon;
    }

    public void initCategory(Function<ResourceLocation, BookCategory> categories) {
        if (this.lcategory == null) {
            if (this.category.contains(":")) {
                this.lcategory = categories.apply(new ResourceLocation(this.category));
            } else {
                Object hint = String.format("`%s:%s`", this.book.getModNamespace(), this.category);
                if (this.isExtension() && !this.trueProvider.getModNamespace().equals(this.book.getModNamespace())) {
                    hint = (String)hint + String.format("or `%s:%s`", this.trueProvider.getModNamespace(), this.category);
                }
                throw new IllegalArgumentException("`category` must be fully qualified (domain:name). Hint: Try " + (String)hint);
            }
        }
    }

    public BookCategory getCategory() {
        return this.lcategory;
    }

    public void updateLockStatus() {
        boolean currLocked = this.locked;
        this.locked = this.advancement != null && !this.advancement.isEmpty() && !ClientAdvancements.hasDone(this.advancement);
        boolean dirty = false;
        if (!this.locked && currLocked) {
            dirty = true;
            this.book.markUpdated();
        }
        if (!dirty && !this.readStateDirty && this.getReadState() == EntryDisplayState.PENDING && ClientAdvancements.hasDone(this.turnin)) {
            dirty = true;
        }
        if (dirty) {
            this.markReadStateDirty();
        }
    }

    public boolean isLocked() {
        if (this.isSecret()) {
            return this.locked;
        }
        return this.getBook().advancementsEnabled() && this.locked;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean shouldHide() {
        return this.isSecret() && this.isLocked();
    }

    public int getEntryColor() {
        return this.entryColor;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean canAdd() {
        return this.flag == null || this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }

    public boolean isFoundByQuery(String query) {
        if (this.getName().getString().toLowerCase().contains(query)) {
            return true;
        }
        for (ItemStackUtil.StackWrapper wrapper : this.relevantStacks) {
            if (!wrapper.stack.m_41786_().getString().toLowerCase().contains(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(BookEntry o) {
        EntryDisplayState otherState;
        if (o.locked != this.locked) {
            return this.locked ? 1 : -1;
        }
        EntryDisplayState ourState = this.getReadState();
        if (ourState != (otherState = o.getReadState())) {
            return ourState.compareTo(otherState);
        }
        if (o.priority != this.priority) {
            return this.priority ? -1 : 1;
        }
        int sort = this.sortnum - o.sortnum;
        return sort == 0 ? this.getName().getString().compareTo(o.getName().getString()) : sort;
    }

    public void setBook(Book book) {
        if (book.isExtension) {
            this.book = book.extensionTarget;
            this.trueProvider = book;
        } else {
            this.book = book;
        }
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public void build(BookContentsBuilder builder) {
        if (this.built) {
            return;
        }
        this.entryColor = this.entryColorRaw != null ? Integer.parseInt(this.entryColorRaw, 16) : this.book.textColor;
        for (int i = 0; i < this.pages.length; ++i) {
            if (!this.pages[i].canAdd(this.book)) continue;
            try {
                this.pages[i].build(this, builder, i);
                this.realPages.add(this.pages[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while loading entry " + this.id + " page " + i, e);
            }
        }
        if (this.extraRecipeMappings != null) {
            for (Map.Entry<String, Integer> entry : this.extraRecipeMappings.entrySet()) {
                List<ItemStack> stacks;
                String key = entry.getKey();
                int pageNumber = entry.getValue();
                try {
                    stacks = ItemStackUtil.loadStackListFromString(key);
                }
                catch (Exception e) {
                    PatchouliAPI.LOGGER.warn("Invalid extra recipe mapping: {} to page {} in entry {}: {}", (Object)key, (Object)pageNumber, (Object)this.id, (Object)e.getMessage());
                    continue;
                }
                if (!stacks.isEmpty() && pageNumber < this.pages.length) {
                    for (ItemStack stack : stacks) {
                        this.addRelevantStack(builder, stack, pageNumber);
                    }
                    continue;
                }
                PatchouliAPI.LOGGER.warn("Invalid extra recipe mapping: {} to page {} in entry {}: Empty entry or page out of bounds", (Object)key, (Object)pageNumber, (Object)this.id);
            }
        }
        this.built = true;
    }

    public void addRelevantStack(BookContentsBuilder builder, ItemStack stack, int page) {
        if (stack.m_41619_()) {
            return;
        }
        ItemStackUtil.StackWrapper wrapper = ItemStackUtil.wrapStack(stack);
        this.relevantStacks.add(wrapper);
        builder.addRecipeMapping(wrapper, this, page / 2);
    }

    public final Book getBook() {
        return this.book;
    }

    public Book getTrueProvider() {
        return this.trueProvider;
    }

    public boolean isExtension() {
        return this.getTrueProvider() != null && this.getTrueProvider() != this.getBook();
    }

    @Override
    protected EntryDisplayState computeReadState() {
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        if (!(data == null || this.getId() == null || this.readByDefault || this.isLocked() || data.viewedEntries.contains(this.getId().toString()))) {
            return EntryDisplayState.UNREAD;
        }
        if (this.turnin != null && !this.turnin.isEmpty() && !ClientAdvancements.hasDone(this.turnin)) {
            return EntryDisplayState.PENDING;
        }
        for (BookPage page : this.pages) {
            if (!(page instanceof PageQuest) || !((PageQuest)page).isCompleted(this.book)) continue;
            return EntryDisplayState.COMPLETED;
        }
        return EntryDisplayState.NEUTRAL;
    }

    @Override
    public void markReadStateDirty() {
        super.markReadStateDirty();
        this.getCategory().markReadStateDirty();
    }
}

