/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.forge.client.jei;

import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.mixin.client.AccessorKeyMapping;

@JeiPlugin
public class PatchouliJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("patchouli", "patchouli");
    private static final KeyMapping showRecipe;
    private static final KeyMapping showUses;
    private static IJeiRuntime jeiRuntime;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(PatchouliItems.BOOK, (stack, context) -> {
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("patchouli:book")) {
                return "";
            }
            return stack.m_41783_().m_128461_("patchouli:book");
        });
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        PatchouliJeiPlugin.jeiRuntime = jeiRuntime;
    }

    public static boolean handleRecipeKeybind(int keyCode, int scanCode, ItemStack stack) {
        if (showRecipe != null && showRecipe.m_90832_(keyCode, scanCode)) {
            IFocus focus = jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, VanillaTypes.ITEM, (Object)stack);
            jeiRuntime.getRecipesGui().show(focus);
            return true;
        }
        if (showUses != null && showUses.m_90832_(keyCode, scanCode)) {
            IFocus focus = jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.INPUT, VanillaTypes.ITEM, (Object)stack);
            jeiRuntime.getRecipesGui().show(focus);
            return true;
        }
        return false;
    }

    static {
        Map<String, KeyMapping> allKeyMappings = AccessorKeyMapping.getAllKeyMappings();
        showRecipe = allKeyMappings.get("key.jei.showRecipe");
        showUses = allKeyMappings.get("key.jei.showUses");
        if (showRecipe == null || showUses == null) {
            PatchouliAPI.LOGGER.warn("Could not locate JEI keybindings, lookups in books may not work");
        }
    }
}

