/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.common.base.Preconditions;
import com.google.gson.JsonPrimitive;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class ConfigEntry<T> {
    public static final Type<Boolean> BOOLEAN = new Type<Boolean>((e, d) -> e.getAsBoolean(), JsonPrimitive::new);
    public static final Type<Integer> INTEGER = new Type<Integer>((e, d) -> e.getAsInt(), JsonPrimitive::new);
    public static final Type<Double> DOUBLE = new Type<Double>((e, d) -> e.getAsDouble(), JsonPrimitive::new);
    public static final Type<String> STRING = new Type<String>((e, d) -> e.getAsString(), JsonPrimitive::new);
    public static final Type<Enum<? extends Enum>> ENUM = new Type<Enum>((e, d) -> Enum.valueOf(d.getDeclaringClass(), e.getAsString()), e -> new JsonPrimitive(e.name()));
    private final ResourceLocation id;
    private final T defaultValue;
    private final T clientOnlyValue;
    private final boolean synced;
    private final Type<T> type;
    private T value;

    private ConfigEntry(ResourceLocation id, T defaultValue, T clientOnlyValue, boolean synced, Type<T> type) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.clientOnlyValue = clientOnlyValue;
        this.synced = synced;
        this.type = type;
    }

    public Type<T> getType() {
        return this.type;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getClientOnlyValue() {
        return this.clientOnlyValue;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        Preconditions.checkArgument((value.getClass() == this.defaultValue.getClass() ? 1 : 0) != 0, (Object)("Tried to assign " + this.defaultValue.getClass() + " with " + value.getClass()));
        this.value = value;
    }

    public static class Type<T> {
        public final BiFunction<JsonPrimitive, T, T> parser;
        public final Function<T, JsonPrimitive> serializer;

        public Type(BiFunction<JsonPrimitive, T, T> parser, Function<T, JsonPrimitive> serializer) {
            this.parser = parser;
            this.serializer = serializer;
        }

        public ConfigEntry<T> create(ResourceLocation id, T defaultValue, T clientOnlyValue, boolean synced) {
            return new ConfigEntry<T>(id, defaultValue, clientOnlyValue, synced, this);
        }
    }
}

