/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.hud.ComponentHandler;
import mcp.mobius.waila.hud.Line;
import mcp.mobius.waila.hud.Tooltip;
import mcp.mobius.waila.hud.TooltipHandler;
import mcp.mobius.waila.util.RaycastUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class ClientTickHandler {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Line SNEAK_DETAIL = new Line(null).with((Component)new TranslatableComponent("tooltip.waila.sneak_for_details").m_130940_(ChatFormatting.ITALIC));

    public static void tick() {
        TooltipHandler.shouldRender = false;
        Minecraft client = Minecraft.m_91087_();
        WailaConfig.General config = Waila.CONFIG.get().getGeneral();
        if (client.f_91073_ == null || !config.isDisplayTooltip()) {
            return;
        }
        if (config.getDisplayMode() == IWailaConfig.General.DisplayMode.HOLD_KEY && !WailaClient.showOverlay.m_90857_()) {
            return;
        }
        if (client.f_91080_ != null && !(client.f_91080_ instanceof ChatScreen)) {
            return;
        }
        if (config.isHideFromPlayerList() && client.f_91065_.m_93088_().f_94524_) {
            return;
        }
        if (config.isHideFromDebug() && client.f_91066_.f_92063_) {
            return;
        }
        HitResult target = RaycastUtil.fire();
        if (target.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        LocalPlayer player = client.f_91074_;
        if (player == null) {
            return;
        }
        DataAccessor accessor = DataAccessor.INSTANCE;
        accessor.set((Level)client.f_91073_, (Player)player, target, client.f_91075_, client.m_91296_());
        TooltipHandler.beginBuild();
        if (target.m_6662_() == HitResult.Type.BLOCK) {
            Block block = accessor.getBlock();
            if (block instanceof LiquidBlock ? !PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_FLUID) : !PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK)) {
                return;
            }
            if (accessor.getBlockState().m_204336_(Waila.BLOCK_BLACKLIST_TAG) || IBlacklistConfig.get().contains(block)) {
                return;
            }
            Object blockEntity = accessor.getBlockEntity();
            if (blockEntity != null && IBlacklistConfig.get().contains((BlockEntity)blockEntity)) {
                return;
            }
            BlockState state = ComponentHandler.getOverrideBlock(target);
            if (state == IBlockComponentProvider.EMPTY_BLOCK_STATE) {
                return;
            }
            accessor.setState(state);
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.HEAD);
            TooltipHandler.add(TOOLTIP);
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.BODY);
            if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.m_6144_()) {
                TooltipHandler.add(SNEAK_DETAIL);
            } else {
                TooltipHandler.add(TOOLTIP);
            }
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.TAIL);
            TooltipHandler.add(TOOLTIP);
        } else if (target.m_6662_() == HitResult.Type.ENTITY) {
            if (!PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY)) {
                return;
            }
            Object actualEntity = accessor.getEntity();
            if (actualEntity == null) {
                return;
            }
            if (actualEntity.m_6095_().m_204039_(Waila.ENTITY_BLACKLIST_TAG) || IBlacklistConfig.get().contains((Entity)accessor.getEntity())) {
                return;
            }
            Entity targetEnt = ComponentHandler.getOverrideEntity(target);
            if (targetEnt == IEntityComponentProvider.EMPTY_ENTITY) {
                return;
            }
            accessor.setEntity(targetEnt);
            if (targetEnt != null) {
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.HEAD);
                TooltipHandler.add(TOOLTIP);
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.BODY);
                if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.m_6144_()) {
                    TooltipHandler.add(SNEAK_DETAIL);
                } else {
                    TooltipHandler.add(TOOLTIP);
                }
                TOOLTIP.clear();
                ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.TAIL);
                TooltipHandler.add(TOOLTIP);
            }
        }
        if (PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ICON)) {
            TooltipHandler.setIcon(ComponentHandler.getIcon(target));
        }
        TooltipHandler.shouldRender = true;
        TooltipHandler.endBuild();
    }
}

