/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.client.gui;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.compat.AddonCompatibleManager;
import beyond_earth_giselle_addon.common.inventory.AbstractMachineContainerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.utils.Rectangle2d;

public class AbstractMachineScreen<M extends AbstractMachineContainerMenu<?, ?>>
extends AbstractContainerScreen<M> {
    public static final String WORKINGAREA_TEXT_PREFIX = AbstractMachineScreen.ctl("workingarea.");
    public static final String WORKINGAREA_TEXT_KEY = WORKINGAREA_TEXT_PREFIX + "text";
    public static final ResourceLocation WORKINGAREA_MIDDLE_TEXTURE = BeyondEarthAddon.rl("textures/gui/workingarea_middle.png");
    public static final ResourceLocation WORKINGAREA_SIDE_TEXTURE = BeyondEarthAddon.rl("textures/gui/workingarea_side.png");
    private boolean cachedWorkingAreaVisible;
    private Button workingAreaVisibleButton;

    public static String ctl(String path) {
        return BeyondEarthAddon.tl("gui", path);
    }

    public AbstractMachineScreen(M menu, Inventory inv, Component text) {
        super(menu, inv, text);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.hasWorkingArea()) {
            this.workingAreaVisibleButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_, this.f_97736_ - 20, 20, 20, (Component)new TextComponent(""), this::onChangeModeButtonClick));
            this.resizeWorkingAreaVisibleButton();
            this.refreshWorkingAreaVisibleButtonMessage();
        }
    }

    public boolean hasWorkingArea() {
        return false;
    }

    public boolean isWorkingAreaVisible() {
        return false;
    }

    @Nullable
    public AABB getWorkingArea() {
        return null;
    }

    public void setWorkingAreaVisible(boolean visible) {
        this.cachedWorkingAreaVisible = visible;
    }

    public void onChangeModeButtonClick(Button button) {
        this.setWorkingAreaVisible(!this.isWorkingAreaVisible());
    }

    public void updateWorkingAreaVisibleButton() {
        boolean next = this.isWorkingAreaVisible();
        if (this.cachedWorkingAreaVisible != next) {
            this.cachedWorkingAreaVisible = next;
            this.refreshWorkingAreaVisibleButtonMessage();
        }
    }

    public void refreshWorkingAreaVisibleButtonMessage() {
        Component message = this.getWorkingAreaVisibleText(this.cachedWorkingAreaVisible);
        this.getWorkingAreaVisibleButton().m_93666_(message);
    }

    public void resizeWorkingAreaVisibleButton() {
        Button workingAreaVisibleButton = this.getWorkingAreaVisibleButton();
        int messageWidth = workingAreaVisibleButton.m_93694_();
        messageWidth = Math.max(messageWidth, this.f_96547_.m_92852_((FormattedText)this.getWorkingAreaVisibleText(true)));
        messageWidth = Math.max(messageWidth, this.f_96547_.m_92852_((FormattedText)this.getWorkingAreaVisibleText(false)));
        workingAreaVisibleButton.m_93674_(messageWidth + 8);
    }

    public Button getWorkingAreaVisibleButton() {
        return this.workingAreaVisibleButton;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        RenderSystem.m_69478_();
        this.renderContents(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
        if (this.hasWorkingArea()) {
            this.updateWorkingAreaVisibleButton();
        }
    }

    protected void renderContents(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
    }

    protected void drawWorkingAreaText(PoseStack stack, @Nullable AABB workingArea, AbstractWidget left) {
        if (workingArea == null) {
            return;
        }
        Component workingAreaText = this.getWorkingAreaBoundsText(workingArea);
        int sideWidth = 1;
        int sidePadding = 2;
        int workingAreaWidth = this.f_96547_.m_92852_((FormattedText)workingAreaText) + sidePadding * 2;
        int workingAreaHeight = 11;
        int workingAreaLeft = left.f_93620_ + left.m_5711_() - this.f_97735_;
        int workignAreaTop = -workingAreaHeight;
        int workingAreaOffsetX = workingAreaLeft;
        RenderSystem.m_157456_((int)0, (ResourceLocation)WORKINGAREA_SIDE_TEXTURE);
        Screen.m_93133_((PoseStack)stack, (int)workingAreaOffsetX, (int)workignAreaTop, (float)0.0f, (float)0.0f, (int)sideWidth, (int)workingAreaHeight, (int)sideWidth, (int)workingAreaHeight);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WORKINGAREA_MIDDLE_TEXTURE);
        Screen.m_93133_((PoseStack)stack, (int)(workingAreaOffsetX += sideWidth), (int)workignAreaTop, (float)0.0f, (float)0.0f, (int)workingAreaWidth, (int)workingAreaHeight, (int)workingAreaWidth, (int)workingAreaHeight);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WORKINGAREA_SIDE_TEXTURE);
        Screen.m_93133_((PoseStack)stack, (int)(workingAreaOffsetX += workingAreaWidth), (int)workignAreaTop, (float)0.0f, (float)0.0f, (int)sideWidth, (int)workingAreaHeight, (int)sideWidth, (int)workingAreaHeight);
        workingAreaOffsetX += sideWidth;
        this.f_96547_.m_92889_(stack, workingAreaText, (float)(workingAreaLeft + sideWidth + sidePadding), (float)(workignAreaTop + 2), 0x303030);
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        super.m_7027_(stack, mouseX, mouseY);
        if (this.hasWorkingArea()) {
            AABB workingArea = this.getWorkingArea();
            this.drawWorkingAreaText(stack, workingArea, (AbstractWidget)this.getWorkingAreaVisibleButton());
        }
    }

    protected void renderEnergy(PoseStack stack, int mouseX, int mouseY, int left, int top, IEnergyStorage energyStorage) {
        GuiHelper.drawEnergy((PoseStack)stack, (int)left, (int)top, (IEnergyStorage)energyStorage);
        if (GuiHelper.isHover((Rectangle2d)GuiHelper.getEnergyBounds((int)left, (int)top), (double)mouseX, (double)mouseY)) {
            this.m_96602_(stack, (Component)GaugeTextHelper.getStorageText((IGaugeValue)GaugeValueHelper.getEnergy((IEnergyStorage)energyStorage)).build(), mouseX, mouseY);
        }
    }

    protected void renderTank(PoseStack stack, int mouseX, int mouseY, int left, int top, FluidTank tank) {
        this.renderTank(stack, mouseX, mouseY, left, top, tank, true);
    }

    protected void renderTank(PoseStack stack, int mouseX, int mouseY, int left, int top, FluidTank tank, boolean renderTooltip) {
        FluidStack fluidInTank = tank.getFluid();
        GuiHelper.drawFluidTank((PoseStack)stack, (int)left, (int)top, (FluidStack)fluidInTank, (int)tank.getCapacity());
        if (renderTooltip && GuiHelper.isHover((Rectangle2d)GuiHelper.getFluidTankBounds((int)left, (int)top), (double)mouseX, (double)mouseY) && (renderTooltip = !AddonCompatibleManager.JEI.isLoaded())) {
            this.m_96602_(stack, (Component)GaugeTextHelper.getStorageText((IGaugeValue)GaugeValueHelper.getFluid((IFluidTank)tank)).build(), mouseX, mouseY);
        }
    }

    protected Component getWorkingAreaBoundsText(AABB workingArea) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        TranslatableComponent workingAreaText = new TranslatableComponent(WORKINGAREA_TEXT_KEY, new Object[]{numberInstance.format(workingArea.m_82362_()), numberInstance.format(workingArea.m_82376_()), numberInstance.format(workingArea.m_82385_())});
        return workingAreaText;
    }

    protected Component getWorkingAreaVisibleText(boolean visible) {
        String method = visible ? "hide" : "show";
        return new TranslatableComponent(WORKINGAREA_TEXT_PREFIX + method);
    }

    protected String rtl(String path) {
        ResourceLocation registryName = ((AbstractMachineContainerMenu)this.m_6262_()).getBlockEntity().m_58903_().getRegistryName();
        return BeyondEarthAddon.tl("gui", registryName, path);
    }
}

