/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.client.gui;

import beyond_earth_giselle_addon.client.gui.AbstractMachineScreen;
import beyond_earth_giselle_addon.client.gui.SimpleCheckBoxButton;
import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.block.entity.ItemStackToItemStackBlockEntityMultiRecipe;
import beyond_earth_giselle_addon.common.inventory.ItemStackToItemStackContainerMenu;
import beyond_earth_giselle_addon.common.network.AbstractMessage;
import beyond_earth_giselle_addon.common.network.AddonNetwork;
import beyond_earth_giselle_addon.common.network.IS2ISMachineMessageAutoEject;
import beyond_earth_giselle_addon.common.network.IS2ISMachineMessageAutoPull;
import beyond_earth_giselle_addon.common.network.IS2ISMachineMessageAutoTransfer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;

public class ItemStackToItemStackScreen<C extends ItemStackToItemStackContainerMenu<C, ?>>
extends AbstractMachineScreen<C> {
    public static final ResourceLocation TEXTURE = BeyondEarthAddon.rl("textures/gui/container/itemstack_to_itemstack.png");
    public static final int ENERGY_LEFT = 144;
    public static final int ENERGY_TOP = 21;
    public static final int ARROW_LEFT = 62;
    public static final int ARROW_TOP = 21;
    public static final int AUTO_PULL_LEFT = 43;
    public static final int AUTO_PULL_TOP = 42;
    public static final Component AUTO_PULL_TEXT = new TranslatableComponent(ItemStackToItemStackScreen.ctl("auto_pull"));
    public static final int AUTO_EJECT_LEFT = 43;
    public static final int AUTO_EJECT_TOP = 55;
    public static final Component AUTO_EJECT_TEXT = new TranslatableComponent(ItemStackToItemStackScreen.ctl("auto_eject"));
    private SimpleCheckBoxButton autoPullButton;
    private SimpleCheckBoxButton autoEjectButton;

    public ItemStackToItemStackScreen(C menu, Inventory inventory, Component text) {
        super(menu, inventory, text);
        this.f_97726_ = 176;
        this.f_97727_ = 168;
        this.f_97731_ = this.f_97727_ - 94;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.autoPullButton = (SimpleCheckBoxButton)this.m_142416_((GuiEventListener)new SimpleCheckBoxButton(this.f_97735_ + 43, this.f_97736_ + 42, AUTO_PULL_TEXT){

            @Override
            public void m_5691_() {
                super.m_5691_();
                ItemStackToItemStackScreen.this.sendmeAutoTransferPacket(IS2ISMachineMessageAutoPull::new, !this.isChecked());
            }
        });
        this.autoPullButton.setAutoToggle(false);
        this.autoEjectButton = (SimpleCheckBoxButton)this.m_142416_((GuiEventListener)new SimpleCheckBoxButton(this.f_97735_ + 43, this.f_97736_ + 55, AUTO_EJECT_TEXT){

            @Override
            public void m_5691_() {
                super.m_5691_();
                ItemStackToItemStackScreen.this.sendmeAutoTransferPacket(IS2ISMachineMessageAutoEject::new, !this.isChecked());
            }
        });
        this.autoEjectButton.setAutoToggle(false);
        this.refreshAutoTransferCheckBoxStates();
    }

    public void sendmeAutoTransferPacket(PacketConstructor constructor, boolean nextState) {
        AddonNetwork.sendToServer((AbstractMessage)constructor.invoke((ItemStackToItemStackBlockEntityMultiRecipe)((Object)((ItemStackToItemStackContainerMenu)this.m_6262_()).getBlockEntity()), nextState));
    }

    protected void m_181908_() {
        super.m_181908_();
        this.refreshAutoTransferCheckBoxStates();
    }

    public void refreshAutoTransferCheckBoxStates() {
        ItemStackToItemStackBlockEntityMultiRecipe blockEntity = (ItemStackToItemStackBlockEntityMultiRecipe)((Object)((ItemStackToItemStackContainerMenu)this.m_6262_()).getBlockEntity());
        this.getAutoPullButton().setChecked(blockEntity.isAutoPull());
        this.getAutoEjectButton().setChecked(blockEntity.isAutoEject());
    }

    @Override
    protected void renderContents(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.renderContents(stack, mouseX, mouseY, partialTicks);
        ItemStackToItemStackBlockEntityMultiRecipe blockEntity = (ItemStackToItemStackBlockEntityMultiRecipe)((Object)((ItemStackToItemStackContainerMenu)this.m_6262_()).getBlockEntity());
        GuiHelper.drawArrow((PoseStack)stack, (int)(this.f_97735_ + 62), (int)(this.f_97736_ + 21), (double)blockEntity.getTimerRatio());
        this.renderEnergy(stack, mouseX, mouseY, this.f_97735_ + 144, this.f_97736_ + 21, blockEntity.getPrimaryEnergyStorage());
    }

    @Override
    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(stack, partialTicks, mouseX, mouseY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTexture());
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    public SimpleCheckBoxButton getAutoPullButton() {
        return this.autoPullButton;
    }

    public SimpleCheckBoxButton getAutoEjectButton() {
        return this.autoEjectButton;
    }

    @FunctionalInterface
    public static interface PacketConstructor {
        public IS2ISMachineMessageAutoTransfer invoke(ItemStackToItemStackBlockEntityMultiRecipe var1, boolean var2);
    }
}

