/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.block.entity;

import beyond_earth_giselle_addon.common.inventory.ItemHandlerHelper3;
import beyond_earth_giselle_addon.common.item.crafting.IS2ISRecipeCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.mrscauthd.beyond_earth.crafting.ItemStackToItemStackRecipe;
import net.mrscauthd.beyond_earth.crafting.ItemStackToItemStackRecipeType;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.inventory.StackCacher;
import net.mrscauthd.beyond_earth.machines.tile.ItemStackToItemStackBlockEntity;

public abstract class ItemStackToItemStackBlockEntityMultiRecipe
extends ItemStackToItemStackBlockEntity {
    public static final String KEY_AUTO_PULL = "auto_pull";
    public static final String KEY_AUTO_EJECT = "auto_eject";
    public static final String KEY_AUTO_TIMER = "auto_timer";
    private StackCacher itemStackCacher = new StackCacher();
    private ItemStackToItemStackRecipe cachedRecipe = null;

    public ItemStackToItemStackBlockEntityMultiRecipe(BlockEntityType<? extends ItemStackToItemStackBlockEntityMultiRecipe> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemStackToItemStackRecipe getCachedRecipe() {
        return this.cachedRecipe;
    }

    public List<IGaugeValue> getGaugeValues() {
        List list = super.getGaugeValues();
        if (this.getCachedRecipe() != null) {
            list.add(this.getCookTimeGaugeValue());
        }
        return list;
    }

    protected boolean onCanPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        if (index == this.getSlotIngredient() && this.nullOrMatch(direction, new Direction[]{Direction.UP})) {
            return this.test(stack) != null;
        }
        if (index == this.getSlotOutput() && direction == null) {
            return true;
        }
        return super.onCanPlaceItemThroughFace(index, stack, direction);
    }

    public List<RecipeType<? extends Recipe<Container>>> getRecipeTypes() {
        return new ArrayList<RecipeType<? extends Recipe<Container>>>();
    }

    public ItemStackToItemStackRecipe test(ItemStack itemStack) {
        Level level = this.m_58904_();
        return IS2ISRecipeCache.cache(level.m_7465_(), level, itemStack, this.getRecipeTypes());
    }

    public ItemStackToItemStackRecipeType<?> getRecipeType() {
        return null;
    }

    protected void clearRecipeCache() {
        this.itemStackCacher.set(ItemStack.f_41583_);
        this.cachedRecipe = null;
        this.setMaxTimer(0);
        this.resetTimer();
    }

    protected void tickAutoTimer() {
        int autoTimer = this.getAutoTimer();
        if (++autoTimer >= this.getAutoMaxTimer()) {
            autoTimer = 0;
            int amount = 1;
            if (this.isAutoPull()) {
                this.tryPull(amount);
            }
            if (this.isAutoEject()) {
                this.tryEject(amount);
            }
        }
        this.setAutoTimer(autoTimer);
    }

    protected LazyOptional<IItemHandler> getTargetItemHandler(Direction direction) {
        BlockPos pos = this.m_58899_().m_141952_(direction.m_122436_());
        BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
        if (blockEntity != null) {
            return blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_());
        }
        return LazyOptional.empty();
    }

    protected void tryPull(int amount) {
        Direction direction = Direction.UP;
        IItemHandler fromItemHandler = (IItemHandler)this.getTargetItemHandler(direction).orElse(null);
        if (fromItemHandler != null) {
            IItemHandler toItemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse(null);
            if (fromItemHandler != null) {
                ItemHandlerHelper3.tryStackTransfer(fromItemHandler, toItemHandler, amount);
            }
        }
    }

    protected void tryEject(int amount) {
        IItemHandler fromItemHandler;
        Direction direction = Direction.DOWN;
        IItemHandler toItemHandler = (IItemHandler)this.getTargetItemHandler(direction).orElse(null);
        if (toItemHandler != null && (fromItemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse(null)) != null) {
            ItemHandlerHelper3.tryStackTransfer(fromItemHandler, toItemHandler, amount);
        }
    }

    protected void tickProcessing() {
        super.tickProcessing();
        this.tickAutoTimer();
    }

    protected ItemStackToItemStackRecipe cacheRecipe() {
        ItemStack itemStack = this.m_8020_(this.getSlotIngredient());
        if (itemStack == null || itemStack.m_41619_()) {
            this.itemStackCacher.set(itemStack);
            this.cachedRecipe = null;
            this.setMaxTimer(0);
        } else if (!this.itemStackCacher.test(itemStack)) {
            this.itemStackCacher.set(itemStack);
            this.cachedRecipe = this.test(itemStack);
            if (this.cachedRecipe != null) {
                this.setMaxTimer(this.cachedRecipe.getCookTime());
            } else {
                this.setMaxTimer(0);
            }
        }
        return this.cachedRecipe;
    }

    public boolean isAutoPull() {
        return this.getTileData().m_128471_(KEY_AUTO_PULL);
    }

    public void setAutoPull(boolean autoPull) {
        if (this.isAutoPull() != autoPull) {
            this.getTileData().m_128379_(KEY_AUTO_PULL, autoPull);
            this.m_6596_();
        }
    }

    public boolean isAutoEject() {
        return this.getTileData().m_128471_(KEY_AUTO_EJECT);
    }

    public void setAutoEject(boolean autoEject) {
        if (this.isAutoEject() != autoEject) {
            this.getTileData().m_128379_(KEY_AUTO_EJECT, autoEject);
            this.m_6596_();
        }
    }

    public int getAutoTimer() {
        return this.getTileData().m_128451_(KEY_AUTO_TIMER);
    }

    public void setAutoTimer(int autoTimer) {
        autoTimer = Math.max(autoTimer, 0);
        if (this.getAutoTimer() != autoTimer) {
            this.getTileData().m_128405_(KEY_AUTO_TIMER, autoTimer);
            this.m_6596_();
        }
    }

    public int getAutoMaxTimer() {
        return 10;
    }
}

