/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.jer;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.compat.AddonCompatibleMod;
import beyond_earth_giselle_addon.common.compat.jer.OreGenBuilder;
import java.util.Arrays;
import java.util.function.Supplier;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.JERAPI;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;

public class AddonJerCompat
extends AddonCompatibleMod {
    public static final String MODID = "jeresources";
    public static final String LANGPREFIX = "jer";

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    @Override
    public String getModID() {
        return MODID;
    }

    @Override
    protected void onLoad() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onFMLCommonSetup);
    }

    private void onFMLCommonSetup(FMLCommonSetupEvent event) {
        AddonJerCompat.registerOreGen();
    }

    public static Restriction getRestriction(Restriction.Type type, ResourceLocation dimension) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension);
        return new Restriction(new DimensionRestriction(type, key));
    }

    public static void registerOreGen() {
        AddonJerCompat.registerMoon();
        AddonJerCompat.registerMars();
        AddonJerCompat.registerMercury();
        AddonJerCompat.registerVenus();
        AddonJerCompat.registerGlacio();
    }

    public static void registerMoon() {
        Restriction restriction = AddonJerCompat.getRestriction(Restriction.Type.WHITELIST, BeyondEarthAddon.prl("moon"));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("moon_cheese_ore"));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("moon_soul_soil"));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("moon_ice_shard_ore"), new Supplier[]{ItemsRegistry.ICE_SHARD});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("moon_iron_ore"), new ItemLike[]{Items.f_151050_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("moon_desh_ore"), new Supplier[]{ItemsRegistry.RAW_DESH});
    }

    public static void registerMars() {
        Restriction restriction = AddonJerCompat.getRestriction(Restriction.Type.WHITELIST, BeyondEarthAddon.prl("mars"));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("mars_ice_shard_ore"), new Supplier[]{ItemsRegistry.ICE_SHARD});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("mars_iron_ore"), new ItemLike[]{Items.f_151050_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("mars_diamond_ore"), new ItemLike[]{Items.f_42415_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("mars_ostrum_ore"), new Supplier[]{ItemsRegistry.RAW_OSTRUM});
    }

    public static void registerMercury() {
        Restriction restriction = AddonJerCompat.getRestriction(Restriction.Type.WHITELIST, BeyondEarthAddon.prl("mercury"));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("mercury_iron_ore"), new ItemLike[]{Items.f_151050_});
    }

    public static void registerVenus() {
        Restriction restriction = AddonJerCompat.getRestriction(Restriction.Type.WHITELIST, BeyondEarthAddon.prl("venus"));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("venus_coal_ore"), new ItemLike[]{Items.f_42413_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("venus_gold_ore"), new ItemLike[]{Items.f_151053_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("venus_diamond_ore"), new ItemLike[]{Items.f_42415_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("venus_calorite_ore"), new Supplier[]{ItemsRegistry.RAW_CALORITE});
    }

    public static void registerGlacio() {
        Restriction restriction = AddonJerCompat.getRestriction(Restriction.Type.WHITELIST, BeyondEarthAddon.prl("glacio"));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_ice_shard_ore"), new Supplier[]{ItemsRegistry.ICE_SHARD});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_coal_ore"), new ItemLike[]{Items.f_42413_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_copper_ore"), new ItemLike[]{Items.f_151051_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_iron_ore"), new ItemLike[]{Items.f_151050_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_lapis_ore"), new ItemStack((ItemLike)Items.f_42534_, 4));
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_deepslate_coal_ore"), new ItemLike[]{Items.f_42413_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_deepslate_copper_ore"), new ItemLike[]{Items.f_151051_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_deepslate_iron_ore"), new ItemLike[]{Items.f_151050_});
        AddonJerCompat.register(restriction, BeyondEarthAddon.prl("glacio_deepslate_lapis_ore"), new ItemStack((ItemLike)Items.f_42534_, 4));
    }

    public static void register(Restriction restriction, ResourceLocation worldGenRegistryName) {
        AddonJerCompat.register(restriction, worldGenRegistryName, new ItemStack[0]);
    }

    @SafeVarargs
    public static void register(Restriction restriction, ResourceLocation worldGenRegistryName, Supplier<Item> ... silkTouchItems) {
        AddonJerCompat.register(restriction, worldGenRegistryName, (ItemLike[])Arrays.stream(silkTouchItems).map(Supplier::get).toArray(ItemLike[]::new));
    }

    public static void register(Restriction restriction, ResourceLocation worldGenRegistryName, ItemLike ... silkTouchItems) {
        AddonJerCompat.register(restriction, worldGenRegistryName, (ItemStack[])Arrays.stream(silkTouchItems).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static void register(Restriction restriction, ResourceLocation worldGenRegistryName, ItemStack ... silkTouchItems) {
        AddonJerCompat.register(restriction, worldGenRegistryName, (LootDrop[])Arrays.stream(silkTouchItems).map(LootDrop::new).toArray(LootDrop[]::new));
    }

    public static void register(Restriction restriction, ResourceLocation worldGenRegistryName, LootDrop ... silkTouchItems) {
        try {
            Registry registry = BuiltinRegistries.f_194653_;
            PlacedFeature placedFeature = (PlacedFeature)registry.m_7745_(worldGenRegistryName);
            if (placedFeature != null) {
                OreGenBuilder builder = new OreGenBuilder().placedFeature(placedFeature);
                builder.restriction = restriction;
                builder.silkTouch = silkTouchItems.length > 0;
                Arrays.stream(silkTouchItems).forEach(builder.drops::add);
                IWorldGenRegistry jer_registry = JERAPI.getInstance().getWorldGenRegistry();
                builder.register(jer_registry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

