/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.compat.mekanism;

import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.api.gear.ICustomModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;

public class AddonModuleHelper {
    public static <T extends ICustomModule<T>> Module<T> findArmorEnabledModule(Entity entity, IModuleDataProvider<T> type) {
        for (ItemStack itemStack : entity.m_6168_()) {
            Module module = ModuleHelper.INSTANCE.load(itemStack, type);
            if (module == null || !module.isEnabled()) continue;
            return module;
        }
        return null;
    }

    public static <T extends ICustomModule<T>> boolean tryCancel(LivingEvent e, IModuleDataProvider<T> type, @Nullable Function<T, FloatingLong> getEnergyUsing) {
        if (!e.isCancelable() || e.isCanceled()) {
            return false;
        }
        LivingEntity entity = e.getEntityLiving();
        Module<T> module = AddonModuleHelper.findArmorEnabledModule((Entity)entity, type);
        if (module != null) {
            boolean cancel = false;
            if (entity instanceof Player && !MekanismUtils.isPlayingMode((Player)((Player)entity))) {
                cancel = true;
            } else if (getEnergyUsing != null) {
                FloatingLong usingEnergy = getEnergyUsing.apply(module.getCustomInstance());
                if (module.canUseEnergy(entity, usingEnergy)) {
                    if (!entity.f_19853_.m_5776_()) {
                        module.useEnergy(entity, usingEnergy);
                    }
                    cancel = true;
                }
            } else {
                cancel = true;
            }
            if (cancel) {
                e.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    private AddonModuleHelper() {
    }
}

