/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.content.proof;

import beyond_earth_giselle_addon.common.BeyondEarthAddon;
import beyond_earth_giselle_addon.common.content.proof.LivingProofEvent;
import beyond_earth_giselle_addon.common.content.proof.LivingSpaceOxygenProofEvent;
import beyond_earth_giselle_addon.common.content.proof.ProofAbstractUtils;
import beyond_earth_giselle_addon.common.content.proof.SpaceOxygenProofEnchantmentSession;
import beyond_earth_giselle_addon.common.enchantment.EnchantmentEnergyStorage;
import beyond_earth_giselle_addon.common.registries.AddonEnchantments;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.mrscauthd.beyond_earth.registries.DamageSourcesRegistry;

public class SpaceOxygenProofUtils
extends ProofAbstractUtils {
    public static final String NBT_KEY = BeyondEarthAddon.rl("space_breathing").toString();
    public static final SpaceOxygenProofUtils INSTANCE = new SpaceOxygenProofUtils();

    private SpaceOxygenProofUtils() {
    }

    @Override
    public String getNBTKey() {
        return NBT_KEY;
    }

    @Override
    public LivingProofEvent createEvent(LivingEntity entity) {
        return new LivingSpaceOxygenProofEvent(entity);
    }

    @SubscribeEvent
    public void onProofEnchantment(LivingSpaceOxygenProofEvent e) {
        LivingEntity entity = e.getEntityLiving();
        SpaceOxygenProofEnchantmentSession session = new SpaceOxygenProofEnchantmentSession(entity, (EnchantmentEnergyStorage)((Object)AddonEnchantments.SPACE_BREATHING.get()));
        e.setProofDuration(session.provide());
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent e) {
        if (e.getSource() != DamageSourcesRegistry.DAMAGE_SOURCE_OXYGEN) {
            return;
        }
        if (this.tryProvideProof((LivingEvent)e)) {
            e.setCanceled(true);
        }
    }
}

