/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerHelper3 {
    public static int indexOf(IItemHandler itemHandler, Item item) {
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_() || stackInSlot.m_41720_() != item) continue;
            return i;
        }
        return -1;
    }

    public static NonNullList<ItemStack> getStacks(IItemHandler handler) {
        NonNullList list = NonNullList.m_122780_((int)handler.getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            list.set(i, (Object)stack);
        }
        return list;
    }

    public static NonNullList<ItemStack> take(IItemHandlerModifiable handler, int amount, boolean simulate) {
        return ItemHandlerHelper3.take(handler, amount, 0, handler.getSlots(), simulate);
    }

    public static NonNullList<ItemStack> take(IItemHandlerModifiable handler, int amount, int startIndex, int endIndex, boolean simulate) {
        int length = endIndex - startIndex;
        NonNullList list = NonNullList.m_122780_((int)length, (Object)ItemStack.f_41583_);
        for (int i = 0; i < length; ++i) {
            ItemStack item = handler.extractItem(startIndex + i, amount, simulate);
            list.set(i, (Object)item);
        }
        return list;
    }

    public static ItemStack tryStackTransfer(IItemHandler from, IItemHandler to, int amount) {
        int fromSlots = from.getSlots();
        for (int fromSlot = 0; fromSlot < fromSlots; ++fromSlot) {
            ItemStack extracting = from.extractItem(fromSlot, amount, true);
            if (extracting.m_41619_()) continue;
            ItemStack inserting = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)extracting, (boolean)true);
            int insertedCount = extracting.m_41613_() - inserting.m_41613_();
            if (insertedCount <= 0) continue;
            ItemStack extracted = from.extractItem(fromSlot, insertedCount, false);
            ItemStack inserted = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)extracted, (boolean)false);
            return inserted;
        }
        return ItemStack.f_41583_;
    }

    private ItemHandlerHelper3() {
    }
}

