/*
 * Decompiled with CFR 0.152.
 */
package beyond_earth_giselle_addon.common.item.crafting;

import beyond_earth_giselle_addon.common.item.crafting.IS2ISRecipeType;
import beyond_earth_giselle_addon.common.item.crafting.IS2ISRecipeTypeBeyondEarth;
import beyond_earth_giselle_addon.common.item.crafting.IS2ISRecipeTypeMinecraftBlasting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.mrscauthd.beyond_earth.crafting.ItemStackToItemStackRecipe;

public class IS2ISRecipeCache {
    private static final List<IS2ISRecipeType<? extends RecipeType<? extends Recipe<Container>>, ? extends Recipe<Container>>> types = new ArrayList<IS2ISRecipeType<? extends RecipeType<? extends Recipe<Container>>, ? extends Recipe<Container>>>();
    private static final Map<Recipe<Container>, ItemStackToItemStackRecipe> caches;

    public static void clearCaches() {
        caches.clear();
    }

    public static List<IS2ISRecipeType<? extends RecipeType<? extends Recipe<Container>>, ? extends Recipe<Container>>> getTypes() {
        return Collections.unmodifiableList(types);
    }

    public static <T extends RecipeType<? extends R>, R extends Recipe<Container>> void addType(IS2ISRecipeType<T, R> type) {
        types.add(type);
    }

    public static ItemStackToItemStackRecipe cache(RecipeManager recipeManager, Level level, ItemStack itemStack, List<RecipeType<? extends Recipe<Container>>> types) {
        for (RecipeType<? extends Recipe<Container>> type : types) {
            ItemStackToItemStackRecipe cache = IS2ISRecipeCache.cache(recipeManager, level, itemStack, type);
            if (cache == null) continue;
            return cache;
        }
        return null;
    }

    public static ItemStackToItemStackRecipe cache(RecipeManager recipeManager, Level level, ItemStack itemStack, RecipeType<? extends Recipe<Container>> type) {
        IS2ISRecipeType findCacheType = IS2ISRecipeCache.findCacheType(type);
        return IS2ISRecipeCache.cache(recipeManager, level, itemStack, type, findCacheType);
    }

    public static <T extends RecipeType<? extends R>, R extends Recipe<Container>> ItemStackToItemStackRecipe cache(RecipeManager recipeManager, Level level, ItemStack itemStack, T recipeType, IS2ISRecipeType<T, R> cacheType) {
        Object recipe = cacheType.find(recipeManager, level, recipeType, itemStack);
        if (recipe != null) {
            return caches.computeIfAbsent((Recipe<Container>)recipe, (Function<Recipe<Container>, ItemStackToItemStackRecipe>)((Function<Recipe, ItemStackToItemStackRecipe>)r -> cacheType.createCache(recipe)));
        }
        return null;
    }

    public static <T extends RecipeType<? extends R>, R extends Recipe<Container>> IS2ISRecipeType<T, R> findCacheType(T recipeType) {
        for (IS2ISRecipeType<? extends RecipeType<? extends Recipe<Container>>, ? extends Recipe<Container>> cacheType : types) {
            if (!cacheType.testRecipeType(recipeType)) continue;
            return cacheType;
        }
        return null;
    }

    private IS2ISRecipeCache() {
    }

    static {
        IS2ISRecipeCache.addType(new IS2ISRecipeTypeBeyondEarth());
        IS2ISRecipeCache.addType(new IS2ISRecipeTypeMinecraftBlasting());
        caches = new HashMap<Recipe<Container>, ItemStackToItemStackRecipe>();
    }
}

