/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.holo_scaffolds;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.MoreMinecartsMod;
import com.alc.moreminecarts.items.HoloRemoteItem;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class HoloScaffold
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_DISTANCE = 15;
    private static final VoxelShape STABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE_BOTTOM;
    private static final VoxelShape BELOW_BLOCK;
    public static final IntegerProperty TRUE_DISTANCE;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty BOTTOM;
    public static final EnumProperty STRENGTH;

    public HoloScaffold(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TRUE_DISTANCE, (Comparable)Integer.valueOf(15))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)STRENGTH, (Comparable)((Object)HoloScaffoldStrength.strong)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{TRUE_DISTANCE, WATERLOGGED, BOTTOM, STRENGTH});
    }

    public static int getDistance(LevelReader reader, BlockPos pos) {
        int min_distance = 16;
        for (Direction direction : Direction.values()) {
            BlockState blockstate1 = reader.m_8055_(pos.m_142300_(direction));
            if (blockstate1.m_60713_(MMReferences.holo_scaffold) || blockstate1.m_60713_(MMReferences.chaotic_holo_scaffold)) {
                min_distance = Math.min(min_distance, (Integer)blockstate1.m_61143_((Property)TRUE_DISTANCE) + 1);
                continue;
            }
            if (!blockstate1.m_60713_(MMReferences.holo_scaffold_generator)) continue;
            return 1;
        }
        return min_distance;
    }

    public boolean isValidDistance(LevelReader reader, BlockPos pos) {
        int distance = HoloScaffold.getDistance(reader, pos);
        return distance >= 0 && distance <= 15;
    }

    private void tickNeighbors(Level world, BlockPos pos, int value, boolean only_greater) {
        for (Direction direction : Direction.values()) {
            BlockPos check_pos = pos.m_142300_(direction);
            BlockState blockstate1 = world.m_8055_(check_pos);
            if (!blockstate1.m_60713_(MMReferences.holo_scaffold) && !blockstate1.m_60713_(MMReferences.chaotic_holo_scaffold)) continue;
            int distance = (Integer)blockstate1.m_61143_((Property)TRUE_DISTANCE);
            if (only_greater && distance >= value) {
                world.m_186464_(check_pos, (Block)this, 1, TickPriority.LOW);
            }
            if (only_greater || distance > value) continue;
            world.m_186464_(check_pos, (Block)this, 1, TickPriority.LOW);
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        super.m_7458_(state, world, pos, rand);
        MoreMinecartsMod.LOGGER.log(org.apache.logging.log4j.Level.WARN, "attempt holo-scaffold tick!");
        int new_distance = HoloScaffold.getDistance((LevelReader)world, pos);
        boolean new_bottom = this.isBottom((Level)world, pos, new_distance);
        if (new_distance == -1 || new_distance > 15) {
            world.m_46961_(pos, true);
            return;
        }
        int old_distance = (Integer)state.m_61143_((Property)TRUE_DISTANCE);
        boolean old_bottom = (Boolean)state.m_61143_((Property)BOTTOM);
        if (new_distance < old_distance) {
            this.tickNeighbors((Level)world, pos, new_distance, true);
        } else if (new_distance > old_distance) {
            this.tickNeighbors((Level)world, pos, new_distance, false);
        }
        if (new_distance != old_distance || new_bottom != old_bottom) {
            world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)TRUE_DISTANCE, (Comparable)Integer.valueOf(new_distance))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((Level)world, pos, new_distance)))).m_61124_((Property)STRENGTH, (Comparable)((Object)HoloScaffoldStrength.getFromLength(new_distance))), 2);
        }
    }

    public void m_6861_(BlockState p_220069_1_, Level p_220069_2_, BlockPos p_220069_3_, Block block, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.m_5776_() && !(block instanceof HoloScaffold)) {
            p_220069_2_.m_186460_(p_220069_5_, (Block)this, 1);
        }
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return this.isValidDistance(p_196260_2_, p_196260_3_);
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public BlockState m_5573_(BlockPlaceContext p_196258_1_) {
        BlockPos blockpos = p_196258_1_.m_8083_();
        Level world = p_196258_1_.m_43725_();
        int i = HoloScaffold.getDistance((LevelReader)world, blockpos);
        if (i < 0) {
            i = 0;
        }
        if (i > 15) {
            i = 15;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)TRUE_DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom(world, blockpos, i)))).m_61124_((Property)STRENGTH, (Comparable)((Object)HoloScaffoldStrength.getFromLength(i)));
    }

    protected boolean isBottom(Level block_reader, BlockPos pos, int distance) {
        return block_reader.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50016_);
    }

    public boolean isScaffolding(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (!p_220053_4_.m_7142_(p_220053_1_.m_60734_().m_5456_())) {
            return (Boolean)p_220053_1_.m_61143_((Property)BOTTOM) != false ? UNSTABLE_SHAPE : STABLE_SHAPE;
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_6079_(BlockState p_199600_1_, BlockGetter p_199600_2_, BlockPos p_199600_3_) {
        return Shapes.m_83144_();
    }

    public boolean m_6864_(BlockState p_196253_1_, BlockPlaceContext p_196253_2_) {
        Item item_in_hand = p_196253_2_.m_43722_().m_41720_();
        return item_in_hand instanceof HoloRemoteItem && (((HoloRemoteItem)item_in_hand).remote_type == HoloRemoteItem.HoloRemoteType.regular || ((HoloRemoteItem)item_in_hand).remote_type == HoloRemoteItem.HoloRemoteType.backwards);
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_196271_4_.m_186469_(p_196271_5_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_196271_4_));
        }
        if (!p_196271_4_.m_5776_()) {
            p_196271_4_.m_186460_(p_196271_5_, (Block)this, 1);
        }
        return p_196271_1_;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (p_220071_4_.m_6513_(Shapes.m_83144_(), p_220071_3_, true) && !p_220071_4_.m_6226_()) {
            return STABLE_SHAPE;
        }
        return (Integer)p_220071_1_.m_61143_((Property)TRUE_DISTANCE) != 0 && (Boolean)p_220071_1_.m_61143_((Property)BOTTOM) != false && p_220071_4_.m_6513_(BELOW_BLOCK, p_220071_3_, true) ? UNSTABLE_SHAPE_BOTTOM : Shapes.m_83040_();
    }

    static {
        UNSTABLE_SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        BELOW_BLOCK = Shapes.m_83144_().m_83216_(0.0, -1.0, 0.0);
        TRUE_DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)0, (int)15);
        WATERLOGGED = BlockStateProperties.f_61362_;
        BOTTOM = BlockStateProperties.f_61427_;
        STRENGTH = EnumProperty.m_61598_((String)"strength", HoloScaffoldStrength.class, (Enum[])new HoloScaffoldStrength[]{HoloScaffoldStrength.strong, HoloScaffoldStrength.weak, HoloScaffoldStrength.weakest});
        VoxelShape voxelshape = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape2 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape4 = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        STABLE_SHAPE = Shapes.m_83124_((VoxelShape)voxelshape, (VoxelShape[])new VoxelShape[]{voxelshape1, voxelshape2, voxelshape3, voxelshape4});
        VoxelShape voxelshape5 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape6 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape8 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
        UNSTABLE_SHAPE = Shapes.m_83124_((VoxelShape)UNSTABLE_SHAPE_BOTTOM, (VoxelShape[])new VoxelShape[]{STABLE_SHAPE, voxelshape6, voxelshape5, voxelshape8, voxelshape7});
    }

    public static enum HoloScaffoldStrength implements StringRepresentable
    {
        weakest,
        weak,
        strong;


        public String m_7912_() {
            switch (this) {
                case strong: {
                    return "strong";
                }
                case weak: {
                    return "weak";
                }
                case weakest: {
                    return "weakest";
                }
            }
            return "ERROR";
        }

        public static HoloScaffoldStrength getFromLength(int length) {
            if (length == 15) {
                return weakest;
            }
            if (length >= 10) {
                return weak;
            }
            return strong;
        }
    }
}

