/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.containers.ChunkLoaderBlock;
import com.alc.moreminecarts.containers.ChunkLoaderContainer;
import com.alc.moreminecarts.tile_entities.ChunkLoaderTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.NetworkHooks;

public class ChunkLoaderCartEntity
extends AbstractMinecartContainer {
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(ChunkLoaderCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return (int)Math.ceil((double)(Math.abs(ChunkLoaderCartEntity.this.time_left) - 1) / 1200.0) * this.m_6413_(1);
                }
                case 1: {
                    return ChunkLoaderCartEntity.this.time_left > 0 ? 1 : -1;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int set_to) {
            switch (index) {
                case 0: {
                    ChunkLoaderCartEntity.this.time_left = set_to * 1200;
                    break;
                }
                case 1: {
                    ChunkLoaderCartEntity.this.time_left = Math.abs(ChunkLoaderCartEntity.this.time_left) * (set_to > 0 ? 1 : -1);
                    break;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public boolean lit_last_tick = false;
    public int time_left = -1;
    public int last_chunk_x = this.m_20097_().m_123341_() >> 4;
    public int last_chunk_z = this.m_20097_().m_123343_() >> 4;

    public ChunkLoaderCartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public ChunkLoaderCartEntity(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public void m_7617_(DamageSource source) {
        super.m_7617_(source);
        if (!source.m_19372_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19998_((ItemLike)MMItemReferences.chunk_loader);
            ChunkLoaderTile.dropExtras(this.f_19853_, this.time_left, this.m_20097_());
        }
        this.onRemoval();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.onRemoval();
    }

    protected AbstractContainerMenu m_7402_(int i, Inventory inv) {
        return new ChunkLoaderContainer(i, this.f_19853_, (Container)this, this.dataAccess, inv, inv.f_35978_);
    }

    protected boolean isMinecartPowered() {
        return (Boolean)this.f_19804_.m_135370_(POWERED);
    }

    protected void setMinecartPowered(boolean powered) {
        this.f_19804_.m_135381_(POWERED, (Object)powered);
    }

    public BlockState m_6390_() {
        return (BlockState)MMReferences.chunk_loader.m_49966_().m_61124_((Property)ChunkLoaderBlock.POWERED, (Comparable)Boolean.valueOf(this.isMinecartPowered()));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6025_(int p_96095_1_, int p_96095_2_, int p_96095_3_, boolean p_96095_4_) {
        this.setEnabled(p_96095_4_);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_(this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_ + 0.5) <= 64.0;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_(ChunkLoaderTile.TIME_LEFT_PROPERTY, this.time_left);
        compound.m_128405_(ChunkLoaderTile.LAST_CHUNK_X_PROPERTY, this.last_chunk_x);
        compound.m_128405_(ChunkLoaderTile.LAST_CHUNK_Z_PROPERTY, this.last_chunk_z);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.time_left = compound.m_128451_(ChunkLoaderTile.TIME_LEFT_PROPERTY);
        this.last_chunk_x = compound.m_128451_(ChunkLoaderTile.LAST_CHUNK_X_PROPERTY);
        this.last_chunk_z = compound.m_128451_(ChunkLoaderTile.LAST_CHUNK_Z_PROPERTY);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POWERED, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        boolean changed_flag = false;
        if (this.isLit()) {
            --this.time_left;
        }
        if (!this.f_19853_.m_5776_()) {
            int burn_duration = ChunkLoaderTile.getBurnDuration(((ItemStack)this.f_38202_.get(0)).m_41720_());
            if (burn_duration >= 0 && Math.abs(this.time_left) + burn_duration <= ChunkLoaderTile.MAX_TIME) {
                changed_flag = true;
                this.time_left = this.time_left > 0 ? (this.time_left += burn_duration) : (this.time_left -= burn_duration);
                ((ItemStack)this.f_38202_.get(0)).m_41774_(1);
            }
            int chunk_x = this.m_20097_().m_123341_() >> 4;
            int chunk_z = this.m_20097_().m_123343_() >> 4;
            if (chunk_x != this.last_chunk_x || chunk_z != this.last_chunk_z) {
                changed_flag = true;
                this.forceChucksAt(this.last_chunk_x, this.last_chunk_z, false);
                this.last_chunk_x = chunk_x;
                this.last_chunk_z = chunk_z;
                boolean bl = this.lit_last_tick = !this.isLit();
            }
            if (this.lit_last_tick != this.isLit()) {
                changed_flag = true;
                if (this.isLit()) {
                    this.forceChucksAt(chunk_x, chunk_z, true);
                } else {
                    this.forceChucksAt(chunk_x, chunk_z, false);
                }
                this.setMinecartPowered(this.isLit());
            }
            if (changed_flag) {
                this.m_6596_();
            }
        }
        this.lit_last_tick = this.isLit();
    }

    private void forceChucksAt(int chunk_x, int chunk_z, boolean add) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_19853_), (String)"moreminecarts", (Entity)this, (int)(chunk_x + i), (int)(chunk_z + j), (boolean)add, (boolean)false);
            }
        }
    }

    public void onRemoval() {
        if (!this.f_19853_.f_46443_) {
            int chunk_x = this.m_20097_().m_123341_() >> 4;
            int chunk_z = this.m_20097_().m_123343_() >> 4;
            this.forceChucksAt(chunk_x, chunk_z, false);
        }
    }

    public boolean isLit() {
        return this.time_left > 1 && this.isEnabled();
    }

    public boolean isEnabled() {
        return this.time_left > 0;
    }

    public void setEnabled(boolean enabled) {
        this.time_left = Math.abs(this.time_left) * (enabled ? 1 : -1);
    }

    public int getComparatorSignal() {
        float true_time_left = Math.abs(this.time_left) - 1;
        double log_proportion = Math.log10(true_time_left / (float)ChunkLoaderTile.MAX_TIME * 9.0f + 1.0f);
        return (int)Math.ceil(log_proportion * 15.0);
    }
}

