/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CouplerEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String COUPLED_COMPOUND = "Couples";
    private static final String TAG_COUPLED_UUID_1 = "coupled_UUID_1";
    private static final String TAG_COUPLED_UUID_2 = "coupled_UUID_2";
    private static final double PREFERRED_DISTANCE = 2.0;
    private CompoundTag vehicleNBTTag;
    public Entity vehicle1;
    public int vehicle1_id;
    public Entity vehicle2;
    public int vehicle2_id;
    public double lastForceX = 0.0;
    public double lastForceY = 0.0;
    public double lastForceZ = 0.0;
    public double lastDiff = 0.0;

    public CouplerEntity(EntityType<?> type, Level worldIn, Entity vehicle1, Entity vehicle2) {
        super(type, worldIn);
        this.vehicle1 = vehicle1;
        this.vehicle1_id = vehicle1.m_142049_();
        this.vehicle2 = vehicle2;
        this.vehicle2_id = vehicle2.m_142049_();
        this.updateDisplay();
    }

    public CouplerEntity(EntityType<CouplerEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
    }

    @Nullable
    public Entity getFirstVehicle() {
        if (this.vehicle1 == null && this.vehicle1_id != 0 && this.f_19853_.f_46443_) {
            this.vehicle1 = this.f_19853_.m_6815_(this.vehicle1_id);
        }
        return this.vehicle1;
    }

    @Nullable
    public Entity getSecondVehicle() {
        if (this.vehicle2 == null && this.vehicle2_id != 0 && this.f_19853_.f_46443_) {
            this.vehicle2 = this.f_19853_.m_6815_(this.vehicle2_id);
        }
        return this.vehicle2;
    }

    public void m_8119_() {
        double distance;
        if (this.f_19853_.f_46443_) {
            this.updateDisplay();
            return;
        }
        if (this.vehicle1 == null || this.vehicle2 == null) {
            this.recreateCouple();
            return;
        }
        if (!this.vehicle1.m_6084_() || !this.vehicle2.m_6084_()) {
            if (this.vehicle1.m_6084_()) {
                this.releaseTensionToOne(true);
            }
            if (this.vehicle2.m_6084_()) {
                this.releaseTensionToOne(false);
            }
            this.onBroken(true);
        }
        if ((distance = (double)this.vehicle1.m_20270_(this.vehicle2)) > 6.0) {
            this.onBroken(true);
        } else {
            double distance_diff;
            Vec3 motion1 = this.vehicle1.m_20184_();
            Vec3 motion2 = this.vehicle2.m_20184_();
            this.lastDiff = distance_diff = distance - 2.0;
            Vec3 between = this.vehicle1.m_20182_().m_82546_(this.vehicle2.m_20182_());
            this.lastForceX = between.f_82479_;
            this.lastForceY = between.f_82480_;
            this.lastForceZ = between.f_82481_;
            Vec3 force = between.m_82541_().m_82490_(CouplerEntity.getSpringForce(distance_diff));
            this.vehicle1.m_20256_(motion1.m_82549_(force.m_82490_(-1.0 * CouplerEntity.getEntityForceScale(this.vehicle1))));
            this.vehicle2.m_20256_(motion2.m_82549_(force.m_82490_(1.0 * CouplerEntity.getEntityForceScale(this.vehicle2))));
            this.vehicle1.m_20256_(this.vehicle1.m_20184_().m_82490_(0.95));
            this.vehicle2.m_20256_(this.vehicle2.m_20184_().m_82490_(0.95));
        }
        super.m_8119_();
        this.updateDisplay();
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_7337_(Entity p_241849_1_) {
        return false;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public static double getEntityForceScale(Entity ent) {
        if (ent instanceof AbstractMinecart && ((AbstractMinecart)ent).m_6064_() == AbstractMinecart.Type.FURNACE) {
            return 0.1;
        }
        return 1.0;
    }

    public static double getSpringForce(double distance) {
        boolean is_neg = distance < 0.0;
        double unsigned = Math.abs(Math.pow(Math.abs(distance), 3.0) * 0.3);
        return is_neg ? -1.0 * unsigned : unsigned;
    }

    public static double getIntegratedSpringForce(double distance) {
        boolean is_neg = distance < 0.0;
        double unsigned = Math.abs(0.3333333333333333 * Math.pow(Math.abs(distance), 4.0) * 0.3);
        return is_neg ? -1.0 * unsigned : unsigned;
    }

    private void recreateCouple() {
        if (this.vehicleNBTTag == null) {
            return;
        }
        if (this.f_19853_ instanceof ServerLevel) {
            UUID uuid;
            Entity entity;
            if (this.vehicleNBTTag.m_128403_(TAG_COUPLED_UUID_1) && (entity = ((ServerLevel)this.f_19853_).m_8791_(uuid = this.vehicleNBTTag.m_128342_(TAG_COUPLED_UUID_1))) != null) {
                this.vehicle1 = entity;
                this.vehicle1_id = this.vehicle1.m_142049_();
            }
            if (this.vehicleNBTTag.m_128403_(TAG_COUPLED_UUID_2) && (entity = ((ServerLevel)this.f_19853_).m_8791_(uuid = this.vehicleNBTTag.m_128342_(TAG_COUPLED_UUID_2))) != null) {
                this.vehicle2 = entity;
                this.vehicle2_id = this.vehicle2.m_142049_();
            }
            if (this.vehicle1 != null && this.vehicle2 != null) {
                MoreMinecartsPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MoreMinecartsPacketHandler.CouplePacket(this.m_142049_(), this.vehicle1_id, this.vehicle2_id));
            }
            if (this.f_19797_ > 100) {
                this.onBroken(true);
                this.vehicleNBTTag = null;
            }
        }
    }

    private void releaseTensionToOne(boolean is_first) {
        Entity to = is_first ? this.vehicle1 : this.vehicle2;
        int scalar = is_first ? 1 : -1;
        Vec3 motion = to.m_20184_();
        Vec3 between = new Vec3(this.lastForceX, this.lastForceY, this.lastForceZ);
        Vec3 force = between.m_82541_().m_82490_(CouplerEntity.getIntegratedSpringForce(this.lastDiff));
        to.m_20256_(motion.m_82549_(force.m_82490_((double)scalar)));
    }

    private void releaseTensionToBoth() {
        Vec3 motion1 = this.vehicle1.m_20184_();
        Vec3 motion2 = this.vehicle2.m_20184_();
        Vec3 between = new Vec3(this.lastForceX, this.lastForceY, this.lastForceZ);
        Vec3 force = between.m_82541_().m_82490_(CouplerEntity.getIntegratedSpringForce(this.lastDiff));
        this.vehicle1.m_20256_(motion1.m_82549_(force.m_82490_(0.5)));
        this.vehicle2.m_20256_(motion2.m_82549_(force.m_82490_(-0.5)));
    }

    public boolean m_7313_(Entity player) {
        if (player instanceof Player) {
            Player playerentity = (Player)player;
            return !this.f_19853_.m_7966_(playerentity, this.m_20097_()) ? true : this.m_6469_(DamageSource.m_19344_((Player)playerentity), 0.0f);
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            this.releaseTensionToBoth();
            this.onBroken(!source.m_19390_());
            this.m_5834_();
        }
        return true;
    }

    public void onBroken(boolean drop_item) {
        this.m_5496_(SoundEvents.f_11794_, 1.0f, 1.0f);
        if (drop_item) {
            this.m_19998_((ItemLike)MMItemReferences.coupler);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128425_(COUPLED_COMPOUND, 10)) {
            this.vehicleNBTTag = compound.m_128469_(COUPLED_COMPOUND);
        }
    }

    public void m_7380_(CompoundTag compound) {
        if (this.vehicle1 != null && this.vehicle2 != null) {
            CompoundTag new_compound = new CompoundTag();
            new_compound.m_128362_(TAG_COUPLED_UUID_1, this.vehicle1.m_142081_());
            new_compound.m_128362_(TAG_COUPLED_UUID_2, this.vehicle2.m_142081_());
            compound.m_128365_(COUPLED_COMPOUND, (Tag)new_compound);
        } else if (this.vehicleNBTTag != null) {
            compound.m_128365_(COUPLED_COMPOUND, (Tag)this.vehicleNBTTag.m_6426_());
        }
    }

    protected void updateDisplay() {
        Entity ent1 = this.getFirstVehicle();
        Entity ent2 = this.getSecondVehicle();
        if (ent1 == null || ent2 == null) {
            return;
        }
        Vec3 v1 = ent1.m_20182_();
        Vec3 v2 = ent2.m_20182_();
        double x = (v1.f_82479_ + v2.f_82479_) / 2.0;
        double y = (v1.f_82480_ + v2.f_82480_) / 2.0;
        double z = (v1.f_82481_ + v2.f_82481_) / 2.0;
        this.m_6034_(x, y, z);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.vehicle1_id);
        buffer.writeInt(this.vehicle2_id);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.vehicle2_id = additionalData.readInt();
        this.vehicle1_id = additionalData.readInt();
    }
}

