/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.items;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.entities.CouplerEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CouplerItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TAG_COUPLED_UUID_1 = "coupled_UUID_1";
    private static final String TAG_COUPLED_UUID_2 = "coupled_UUID_2";

    public CouplerItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128403_(TAG_COUPLED_UUID_1) && tag.m_128403_(TAG_COUPLED_UUID_2) && entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.m_5496_(SoundEvents.f_11745_, 0.7f, 1.0f);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            CouplerItem.clearCoupler(stack);
            return;
        }
        if (!(worldIn instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)worldIn;
        if (tag.m_128403_(TAG_COUPLED_UUID_1) && tag.m_128403_(TAG_COUPLED_UUID_2)) {
            double distance;
            UUID uuid1 = tag.m_128342_(TAG_COUPLED_UUID_1);
            Entity ent1 = world.m_8791_(uuid1);
            UUID uuid2 = tag.m_128342_(TAG_COUPLED_UUID_2);
            Entity ent2 = world.m_8791_(uuid2);
            if (ent1 != null && ent2 != null && ent1 != ent2 && (distance = (double)ent1.m_20270_(ent2)) < 3.0) {
                Vec3 center_pos = new Vec3((ent1.m_20182_().f_82479_ + ent2.m_20182_().f_82479_) / 2.0, (ent1.m_20182_().f_82480_ + ent2.m_20182_().f_82480_) / 2.0, (ent1.m_20182_().f_82481_ + ent2.m_20182_().f_82481_) / 2.0);
                List list = worldIn.m_142425_(MMReferences.coupler, new AABB(center_pos.f_82479_ + 0.5, center_pos.f_82480_ + 0.5, center_pos.f_82481_ + 0.5, center_pos.f_82479_ - 0.5, center_pos.f_82480_ - 0.5, center_pos.f_82481_ - 0.5), entity -> true);
                boolean is_duplicate = false;
                for (CouplerEntity ent : list) {
                    if ((ent.getFirstVehicle() != ent1 || ent.getSecondVehicle() != ent2) && (ent.getSecondVehicle() != ent1 || ent.getFirstVehicle() != ent2)) continue;
                    is_duplicate = true;
                    break;
                }
                if (!is_duplicate) {
                    CouplerEntity coupler_ent = new CouplerEntity(MMReferences.coupler, worldIn, ent1, ent2);
                    worldIn.m_7967_((Entity)coupler_ent);
                    tag.m_128473_(TAG_COUPLED_UUID_1);
                    return;
                }
            }
            CouplerItem.clearCoupler(stack);
        }
    }

    public static void hookIn(Player player, Level worldIn, ItemStack used, Entity vehicle) {
        CompoundTag tag = used.m_41784_();
        if (tag.m_128403_(TAG_COUPLED_UUID_2)) {
            // empty if block
        }
        if (tag.m_128403_(TAG_COUPLED_UUID_1)) {
            UUID uuid = vehicle.m_142081_();
            tag.m_128362_(TAG_COUPLED_UUID_2, uuid);
        } else {
            UUID uuid = vehicle.m_142081_();
            tag.m_128362_(TAG_COUPLED_UUID_1, uuid);
            tag.m_128405_("CustomModelData", 1);
        }
    }

    public static void clearCoupler(ItemStack used) {
        CompoundTag tag = used.m_41784_();
        tag.m_128473_(TAG_COUPLED_UUID_1);
        tag.m_128473_(TAG_COUPLED_UUID_2);
        tag.m_128405_("CustomModelData", 0);
    }
}

