/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.util;

import betteradvancements.util.CriteriaDetail;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class CriterionGrid {
    public static CriteriaDetail detailLevel = CriteriaDetail.DEFAULT;
    public static boolean requiresShift = false;
    private static final CriterionGrid empty = new CriterionGrid();
    private final List<String> cellContents;
    private final int[] cellWidths;
    private final int fontHeight;
    private final int numColumns;
    public final int numRows;
    public List<Column> columns;
    public int width;
    public int height;

    private CriterionGrid() {
        this.cellContents = Collections.emptyList();
        this.cellWidths = new int[0];
        this.fontHeight = 0;
        this.numColumns = 0;
        this.numRows = 0;
        this.columns = Collections.emptyList();
        this.width = 0;
        this.height = 0;
    }

    public CriterionGrid(List<String> cellContents, int[] cellWidths, int fontHeight, int numColumns) {
        this.cellContents = cellContents;
        this.cellWidths = cellWidths;
        this.fontHeight = fontHeight;
        this.numColumns = numColumns;
        this.numRows = (int)Math.ceil((double)cellContents.size() / (double)numColumns);
    }

    public void init() {
        this.columns = new ArrayList<Column>();
        this.width = 0;
        for (int c = 0; c < this.numColumns; ++c) {
            int cellIndex;
            ArrayList<String> column = new ArrayList<String>();
            int columnWidth = 0;
            for (int r = 0; r < this.numRows && (cellIndex = c * this.numRows + r) < this.cellContents.size(); ++r) {
                String str = this.cellContents.get(cellIndex);
                column.add(str);
                columnWidth = Math.max(columnWidth, this.cellWidths[cellIndex]);
            }
            this.columns.add(new Column(column, columnWidth));
            this.width += columnWidth;
        }
        this.height = this.numRows * this.fontHeight;
    }

    public static CriterionGrid findOptimalCriterionGrid(Advancement advancement, AdvancementProgress progress, int maxWidth, Font font) {
        if (progress == null || progress.m_8193_() || detailLevel.equals((Object)CriteriaDetail.OFF)) {
            return empty;
        }
        Map criteria = advancement.m_138325_();
        if (criteria.size() <= 1) {
            return empty;
        }
        int numUnobtained = 0;
        ArrayList<String> cellContents = new ArrayList<String>();
        for (String criterion : criteria.keySet()) {
            MutableComponent text2;
            MutableComponent text;
            if (progress.m_8214_(criterion).m_12911_()) {
                if (!detailLevel.showObtained()) continue;
                text = new TextComponent(" + ").m_130940_(ChatFormatting.GREEN);
                text2 = new TextComponent(criterion).m_130940_(ChatFormatting.WHITE);
                text.m_7220_((Component)text2);
                cellContents.add(text.getString());
                continue;
            }
            if (detailLevel.showUnobtained()) {
                text = new TextComponent(" x ").m_130940_(ChatFormatting.DARK_RED);
                text2 = new TextComponent(criterion).m_130940_(ChatFormatting.WHITE);
                text.m_7220_((Component)text2);
                cellContents.add(text.getString());
            }
            ++numUnobtained;
        }
        if (!detailLevel.showUnobtained()) {
            MutableComponent text = new TextComponent(" x ").m_130940_(ChatFormatting.DARK_RED);
            MutableComponent text2 = new TextComponent(numUnobtained + " remaining").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC});
            text.m_7220_((Component)text2);
            cellContents.add(text.getString());
        }
        int[] cellWidths = new int[cellContents.size()];
        for (int i = 0; i < cellWidths.length; ++i) {
            cellWidths[i] = font.m_92895_((String)cellContents.get(i));
        }
        int numCols = 0;
        CriterionGrid prevGrid = null;
        CriterionGrid currGrid = null;
        do {
            Objects.requireNonNull(font);
            CriterionGrid newGrid = new CriterionGrid(cellContents, cellWidths, 9, ++numCols);
            if (prevGrid != null && newGrid.numRows == prevGrid.numRows) continue;
            newGrid.init();
            prevGrid = currGrid;
            currGrid = newGrid;
        } while (numCols <= cellContents.size() && currGrid.width <= maxWidth);
        return prevGrid != null ? prevGrid : currGrid;
    }

    public class Column {
        public final List<String> cells;
        public final int width;

        public Column(List<String> cells, int width) {
            this.cells = cells;
            this.width = width;
        }
    }
}

