/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public interface IRenderedTankUpgrade {
    public void setTankRenderInfoUpdateCallback(Consumer<TankRenderInfo> var1);

    public void forceUpdateTankRenderInfo();

    public static class TankRenderInfo {
        private static final String FLUID_REGISTRY_NAME_TAG = "fluidRegistryName";
        private static final String FILL_RATIO_TAG = "fillRatio";
        @Nullable
        private ResourceLocation fluidRegistryName;
        private float fillRatio;

        public TankRenderInfo() {
            this(null, 0.0f);
        }

        public TankRenderInfo(@Nullable ResourceLocation fluidRegistryName, float fillRatio) {
            this.fluidRegistryName = fluidRegistryName;
            this.fillRatio = fillRatio;
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (this.fluidRegistryName != null) {
                ret.m_128359_(FLUID_REGISTRY_NAME_TAG, this.fluidRegistryName.toString());
                ret.m_128350_(FILL_RATIO_TAG, this.fillRatio);
            }
            return ret;
        }

        public static TankRenderInfo deserialize(CompoundTag tag) {
            if (tag.m_128441_(FLUID_REGISTRY_NAME_TAG)) {
                return new TankRenderInfo(new ResourceLocation(tag.m_128461_(FLUID_REGISTRY_NAME_TAG)), tag.m_128457_(FILL_RATIO_TAG));
            }
            return new TankRenderInfo();
        }

        public void setFluid(Fluid fluid) {
            this.fluidRegistryName = fluid.getRegistryName();
        }

        public Optional<Fluid> getFluid() {
            return Optional.ofNullable((Fluid)ForgeRegistries.FLUIDS.getValue(this.fluidRegistryName));
        }

        public void setFillRatio(float fillRatio) {
            this.fillRatio = fillRatio;
        }

        public float getFillRatio() {
            return this.fillRatio;
        }
    }
}

